(ns edd.memory.middleware
  (:require [lambda.core :as lambda-core]
            [edd.common :as edd-common]
            [lambda.util :as util]
            [aws.ctx :as aws-ctx]))

(defn memory->process-response
  [ctx {:keys [error
               exception]
        :as response}]
  (cond
    error
    response

    exception
    response

    :else
    (update response
            :result
            #(->> %
                  (edd-common/response->response-summary ctx)))))

(deftype EddMemoryMiddleware [config]
  lambda-core/LambdaMiddlware
  (init-middleware [_this ctx]
    (-> ctx
        aws-ctx/init))

  (do-process [_this ctx request  middleware-chain]
    (let [response (lambda-core/continue-process  middleware-chain ctx request)]
      (util/d-time
       "Execution EddMemoryMiddleware/do-process"
       (memory->process-response ctx response)))))


