(ns edd.i18n
  (:require [edd.db :as db]
            [re-frame.db :as re-frame-db]
            [clojure.string :as str]))

(def base-translations
  {:language {:en "English"
              :de "Deutsch"}})

(def TranslationSchema [:map
                        []])

(defn- format-string
  [s params]
  (cond
    (vector? params)
    (reduce-kv 
     (fn [acc idx val]
       (str/replace acc (str "{" idx "}") (str val)))
     s
     params)
    
    (map? params)
    (reduce-kv
     (fn [acc k v]
       (str/replace acc (str "{" (name k) "}") (str v)))
     s
     params)
    
    :else s))

(defn tr
  [& args]
  (let [lang (get @re-frame-db/app-db ::db/selected-language)
        [message-spec params] (if (map? (first args))
                                [(first args) nil]
                                [args nil])
        message-key (if (map? message-spec)
                      (:message message-spec)
                      (if (keyword? (first message-spec))
                        message-spec
                        (first message-spec)))
        params (or (:params message-spec) params)
        prop (if (keyword? message-key)
               [message-key]
               message-key)
        prop (vec (concat [lang] prop))
        val (get-in (get @re-frame-db/app-db ::db/translations)
                    prop
                    (str "{tr " prop "}"))]
    (when-not (string? val)
      (throw (js/Error. (str
                         "Translation key does not result in string: "
                         (->> {:key prop
                               :value val}
                              clj->js
                              (.stringify js/JSON))))))
    (if params
      (format-string val params)
      val)))

(comment
  (defn convert-structure
    [in out path]
    (reduce
     (fn [out-p v]
       (let [value (get in v)
             current-path (conj path v)
             new-path (vec
                       (cons v path))]
         (println "Processing: " current-path new-path out-p value)
         (if (map? value)
           (convert-structure value
                              out-p
                              current-path)
           (assoc-in out-p
                     new-path
                     value))))
     out
     (keys in)))
  (clojure.pprint/pprint
   (convert-structure (tr)
                      {}
                      [])))

