(ns jaq.services.compute
  (:refer-clojure :exclude [list])
  (:require
   [clojure.data.json :as json]
   [clojure.edn :as edn]
   [clojure.tools.logging :as log]
   [clojure.java.io :as io]
   [clojure.walk :as walk]
   [clojure.string :as string]
   [clj-http.lite.client :as http]
   [ring.util.mime-type :refer [ext-mime-type]]
   [jaq.services.deferred :refer [defer defer-fn]]
   [jaq.services.util :as util])
  (:import
   [java.io File]
   [com.google.appengine.api.appidentity
    AppIdentityServiceFactory
    AppIdentityService]))

(def endpoint "https://www.googleapis.com")
(def version "v1")
(def default-endpoint [endpoint :storage version])
(def action (partial util/action default-endpoint))
