(ns jaq.services.script
  (:refer-clojure :exclude [list])
  (:require
   [clojure.data.json :as json]
   [clojure.data.xml :as xml]
   [clojure.tools.logging :as log]
   [clojure.java.io :as io]
   [clj-http.lite.client :as http]
   [clojure.string :as string]
   [jaq.services.storage :as storage]
   [jaq.services.util :as util]))

(def api-endpoint "https://script.googleapis.com")
(def api-version "v1")
(def default-endpoint [api-endpoint api-version])
(def action (partial util/action default-endpoint))

(defn processes [& [{:keys [pageToken pageSize] :as params}]]
  (lazy-seq
   (let [result (action :get [:processes]
                        {:query-params params})
         next-token (:nextPageToken result)]
     (concat (:queues result) (when next-token
                                (processes (assoc params :pageToken next-token)))))))

(defn project [scriptId]
  (action :get [:projects scriptId]))

(defn create-project [{:keys [title parentId] :as params}]
  (action :post [:projects] {:content-type :json
                             :body (json/write-str params)}))

(defn run-script [scriptId function args]
  (action :post [:scripts (str scriptId ":run")]
          {:content-type "application-json"
           :body (json/write-str {:function "test"
                                  :devMode true})}))

#_(
   *ns*
   (in-ns 'jaq.services.script)

   (create-project {:title "foo bar"})

   (processes)


   (json/write-str {:function "test"
                    ;;:parameters args
                    })

   (def scriptId "1oFLGUZLoocs1_IMohFG4YRwpFA9kfNreHxgPJ-LAhiU7Adgo4-VZ38Ov")

   (project scriptId)
   (run-script "1oFLGUZLoocs1_IMohFG4YRwpFA9kfNreHxgPJ-LAhiU7Adgo4-VZ38Ov" "test" [])

   )
