(ns jaq.runtime
  (:require
   [ring.util.response :as response]
   [ring.util.servlet :refer [defservice]]
   [ring.middleware.defaults :refer [wrap-defaults site-defaults]]
   [ring.middleware.params :refer [wrap-params]]
   [ring.middleware.edn :refer [wrap-edn-params]]
   [jaq.services.util :refer [remote! repl-server]]))

(declare handler)

(defmulti listener-fn :fn)
(defmethod listener-fn :default [_])

(defn init []
  (require 'jaq.bootstrap)
  (listener-fn {:fn :init}))

(defn destroy []
  (listener-fn {:fn :destroy}))

(def app
  (-> #'handler
      (wrap-defaults (assoc-in site-defaults [:security :anti-forgery] false))
      (wrap-edn-params)))

(defservice app)
