/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.xml;

import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.SAXFilterHandler;
import com.aliasi.xml.SimpleElementHandler;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegatingHandler
extends SimpleElementHandler {
    final Map<String, DefaultHandler> mDelegateMap = new HashMap<String, DefaultHandler>();
    final String[] mQNameStack;
    final DefaultHandler[] mDelegateStack;
    int mStackTop = -1;

    public DelegatingHandler(int maxDelegationDepth) {
        this.mDelegateStack = new DefaultHandler[maxDelegationDepth];
        this.mQNameStack = new String[maxDelegationDepth];
    }

    public DelegatingHandler() {
        this(512);
    }

    public void setDelegate(String qName, DefaultHandler handler) {
        if (handler instanceof DelegateHandler && this != ((DelegateHandler)handler).mDelegatingHandler) {
            String msg = "Delegate handlers must wrap this delegating handler.";
            throw new IllegalArgumentException(msg);
        }
        this.mDelegateMap.put(qName, handler);
    }

    public void finishDelegate(String qName, DefaultHandler handler) {
    }

    public DefaultHandler getDelegate(String qName) {
        return this.mDelegateMap.get(qName);
    }

    @Override
    public void startDocument() throws SAXException {
        this.mStackTop = -1;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].startElement(namespaceURI, localName, qName, atts);
            return;
        }
        DefaultHandler handler = this.getDelegate(qName);
        if (handler == null) {
            return;
        }
        handler.startDocument();
        handler.startElement(namespaceURI, localName, qName, atts);
        this.mStackTop = 0;
        this.mDelegateStack[0] = handler;
        this.mQNameStack[0] = qName;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.mStackTop < 0) {
            return;
        }
        DefaultHandler handler = this.mDelegateStack[this.mStackTop];
        handler.endElement(namespaceURI, localName, qName);
        if (!qName.equals(this.mQNameStack[this.mStackTop])) {
            return;
        }
        handler.endDocument();
        --this.mStackTop;
        if (this.mStackTop < 0) {
            this.finishDelegate(qName, handler);
        } else {
            DelegateHandler delHandler = (DelegateHandler)this.mDelegateStack[this.mStackTop];
            delHandler.finishDelegate(qName, handler);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].processingInstruction(target, data);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].endPrefixMapping(prefix);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].skippedEntity(name);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].setDocumentLocator(locator);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return this.mStackTop < 0 ? super.resolveEntity(publicId, systemId) : this.mDelegateStack[this.mStackTop].resolveEntity(publicId, systemId);
        }
        catch (Throwable t) {
            SAXFilterHandler.io2SAXException(t);
            return null;
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].fatalError(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].warning(exception);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.mStackTop >= 0) {
            this.mDelegateStack[this.mStackTop].unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }
}

