/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.xml.sax.InputSource;

public class Streams {
    private static final int BYTE_COPY_BUFFER_SIZE = 8192;
    private static final int CHAR_COPY_BUFFER_SIZE = 4096;

    private Streams() {
    }

    public static String getDefaultJavaCharset() {
        byte[] bytes = new byte[]{};
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        InputStreamReader defaultReader = new InputStreamReader(bytesIn);
        return defaultReader.getEncoding();
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.copy(in, out);
        return out.toByteArray();
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        Streams.copy(reader, writer);
        return writer.toCharArray();
    }

    public static char[] toCharArray(InputStream in, String charset) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        InputStreamReader reader = new InputStreamReader(in, charset);
        Streams.copy(reader, writer);
        return writer.toCharArray();
    }

    public static char[] toCharArray(InputSource in) throws IOException {
        Reader reader = null;
        InputStream inStr = null;
        reader = in.getCharacterStream();
        if (reader == null) {
            String charset;
            inStr = in.getByteStream();
            if (inStr == null) {
                inStr = new URL(in.getSystemId()).openStream();
            }
            reader = (charset = in.getEncoding()) == null ? new InputStreamReader(inStr) : new InputStreamReader(inStr, charset);
        }
        return Streams.toCharArray(reader);
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int numChars;
        char[] buffer = new char[4096];
        while ((numChars = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, numChars);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int numBytes;
        byte[] buffer = new byte[8192];
        while ((numBytes = in.read(buffer)) > 0) {
            out.write(buffer, 0, numBytes);
        }
    }

    public static IOException closeQuietly(Closeable c) {
        if (c == null) {
            return null;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeInputSource(InputSource in) {
        if (in == null) {
            return;
        }
        try {
            Streams.closeInputStream(in.getByteStream());
        }
        finally {
            Streams.closeReader(in.getCharacterStream());
        }
    }

    @Deprecated
    public static void closeInputStream(InputStream in) {
        Streams.closeQuietly(in);
    }

    @Deprecated
    public static void closeOutputStream(OutputStream out) {
        Streams.closeQuietly(out);
    }

    @Deprecated
    public static void closeReader(Reader reader) {
        Streams.closeQuietly(reader);
    }

    @Deprecated
    public static void closeWriter(Writer writer) {
        Streams.closeQuietly(writer);
    }
}

