/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.CompactHashSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class BinaryMap<E>
extends AbstractMap<E, Integer>
implements Serializable {
    static final long serialVersionUID = -6965494782866980478L;
    private final Set<E> mPositiveSet;
    public static final Integer ONE = 1;
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public BinaryMap() {
        this(1);
    }

    public BinaryMap(int initialCapacity) {
        this(new CompactHashSet(initialCapacity));
    }

    public BinaryMap(Set<E> positiveSet) {
        this.mPositiveSet = positiveSet;
    }

    public boolean add(E e) {
        return this.mPositiveSet.add(e);
    }

    @Override
    public Set<E> keySet() {
        return this.mPositiveSet;
    }

    @Override
    public Set<Map.Entry<E, Integer>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Integer get(Object key) {
        return this.mPositiveSet.contains(key) ? ONE : null;
    }

    @Override
    public Integer remove(Object key) {
        return this.mPositiveSet.remove(key) ? ONE : null;
    }

    @Override
    public int size() {
        return this.mPositiveSet.size();
    }

    @Override
    public Collection<Integer> values() {
        return new Values();
    }

    @Override
    public void clear() {
        this.mPositiveSet.clear();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.mPositiveSet.contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return ONE.equals(o) && !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.mPositiveSet.isEmpty();
    }

    @Override
    public Integer put(E e, Integer n) {
        if (!ONE.equals(n)) {
            throw new IllegalArgumentException();
        }
        return this.mPositiveSet.add(e) ? null : ONE;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -1922361159364699771L;
        final BinaryMap<F> mMap;

        public Serializer() {
            this(null);
        }

        public Serializer(BinaryMap<F> map) {
            this.mMap = map;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(((BinaryMap)this.mMap).mPositiveSet);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            Set positiveSet = (Set)in.readObject();
            return new BinaryMap(positiveSet);
        }
    }

    class EntrySetIterator
    implements Iterator<Map.Entry<E, Integer>> {
        private final Iterator<E> mIterator;

        EntrySetIterator() {
            this.mIterator = BinaryMap.this.mPositiveSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public Map.Entry<E, Integer> next() {
            return new PositiveMapEntry();
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }

        class PositiveMapEntry
        implements Map.Entry<E, Integer> {
            private final E mE;

            PositiveMapEntry() {
                this.mE = EntrySetIterator.this.mIterator.next();
            }

            @Override
            public E getKey() {
                return this.mE;
            }

            @Override
            public Integer getValue() {
                return ONE;
            }

            @Override
            public Integer setValue(Integer value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object that) {
                if (!(that instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e1 = (Map.Entry)that;
                PositiveMapEntry e2 = this;
                return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
            }

            @Override
            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<E, Integer>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return BinaryMap.this.mPositiveSet.size();
        }

        @Override
        public Iterator<Map.Entry<E, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public void clear() {
            BinaryMap.this.mPositiveSet.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ONE.equals(entry.getValue()) && BinaryMap.this.mPositiveSet.contains(entry.getKey());
        }

        @Override
        public boolean isEmpty() {
            return BinaryMap.this.mPositiveSet.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ONE.equals(entry.getValue()) && BinaryMap.this.mPositiveSet.remove(entry.getKey());
        }
    }

    class ValuesIterator
    implements Iterator<Integer> {
        boolean finished;
        boolean mayRemove;

        ValuesIterator() {
            this.finished = BinaryMap.this.mPositiveSet.isEmpty();
            this.mayRemove = false;
        }

        @Override
        public boolean hasNext() {
            return !this.finished;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.finished = true;
            this.mayRemove = true;
            return ONE;
        }

        @Override
        public void remove() {
            if (!this.mayRemove) {
                throw new IllegalStateException();
            }
            this.mayRemove = false;
            BinaryMap.this.mPositiveSet.clear();
        }
    }

    class Values
    extends AbstractCollection<Integer> {
        Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            BinaryMap.this.mPositiveSet.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ONE.equals(o) && !this.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return BinaryMap.this.mPositiveSet.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (!ONE.equals(o)) {
                return false;
            }
            boolean removedSomething = !this.isEmpty();
            BinaryMap.this.mPositiveSet.clear();
            return removedSomething;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (!c.contains(ONE)) {
                return false;
            }
            boolean removedSomething = !this.isEmpty();
            BinaryMap.this.mPositiveSet.clear();
            return removedSomething;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this.isEmpty()) {
                return false;
            }
            if (c.contains(ONE)) {
                return false;
            }
            BinaryMap.this.mPositiveSet.clear();
            return true;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray;
            if (this.isEmpty()) {
                objectArray = EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = ONE;
            }
            return objectArray;
        }
    }
}

