/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.ModifiedTokenizerFactory;
import com.aliasi.tokenizer.ModifyTokenTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class TokenLengthTokenizerFactory
extends ModifyTokenTokenizerFactory
implements Serializable {
    static final long serialVersionUID = -431337104035802336L;
    private final int mShortestTokenLength;
    private final int mLongestTokenLength;

    public TokenLengthTokenizerFactory(TokenizerFactory factory, int shortestTokenLength, int longestTokenLength) {
        super(factory);
        if (shortestTokenLength < 0) {
            String msg = "Shortest token length must be non-negative. Found shortestTokenLength=" + shortestTokenLength;
            throw new IllegalArgumentException(msg);
        }
        if (shortestTokenLength > longestTokenLength) {
            String msg = "Shortest token length must be <= longest. Found shortestTokenLength=" + shortestTokenLength + " longestTokenLength=" + longestTokenLength;
            throw new IllegalArgumentException(msg);
        }
        this.mShortestTokenLength = shortestTokenLength;
        this.mLongestTokenLength = longestTokenLength;
    }

    @Override
    public String modifyToken(String token) {
        return token.length() < this.mShortestTokenLength || token.length() > this.mLongestTokenLength ? null : token;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "\n  min length=" + this.mShortestTokenLength + "\n  max length=" + this.mLongestTokenLength + "\n  base factory=\n    " + this.baseTokenizerFactory().toString().replace("\n", "\n    ");
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends ModifiedTokenizerFactory.AbstractSerializer<TokenLengthTokenizerFactory> {
        static final long serialVersionUID = -8886994304636616691L;

        public Serializer() {
            this(null);
        }

        public Serializer(TokenLengthTokenizerFactory factory) {
            super(factory);
        }

        @Override
        public void writeExternalRest(ObjectOutput out) throws IOException {
            out.writeInt(((TokenLengthTokenizerFactory)this.factory()).mShortestTokenLength);
            out.writeInt(((TokenLengthTokenizerFactory)this.factory()).mLongestTokenLength);
        }

        @Override
        public Object read(ObjectInput in, TokenizerFactory baseFactory) throws IOException {
            int shortest = in.readInt();
            int longest = in.readInt();
            return new TokenLengthTokenizerFactory(baseFactory, shortest, longest);
        }
    }
}

