/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.AbstractDiscreteDistribution;
import com.aliasi.util.Math;

public abstract class PoissonDistribution
extends AbstractDiscreteDistribution {
    protected PoissonDistribution() {
    }

    @Override
    public abstract double mean();

    @Override
    public double variance() {
        return this.mean();
    }

    @Override
    public long minOutcome() {
        return 0L;
    }

    @Override
    public final double log2Probability(long outcome) {
        return PoissonDistribution.log2Poisson(this.mean(), outcome);
    }

    @Override
    public final double probability(long outcome) {
        return java.lang.Math.pow(2.0, this.log2Probability(outcome));
    }

    private static double log2Poisson(double lambda, long k) {
        if (lambda <= 0.0 || Double.isInfinite(lambda)) {
            String msg = "Mean must be a positive non-infiite value. Found mean=" + lambda;
            throw new IllegalStateException(msg);
        }
        if (k < 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        return -lambda * Math.LOG2_E + (double)k * Math.log2(lambda) - Math.log2Factorial(k);
    }
}

