/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.BernoulliConstant;
import com.aliasi.stats.BernoulliDistribution;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BernoulliEstimator
extends BernoulliDistribution
implements Compilable {
    long mTotalCount;
    long mSuccessCount;

    public void train(boolean success, int numSamples) {
        this.mTotalCount += (long)numSamples;
        if (success) {
            this.mSuccessCount += (long)numSamples;
        }
    }

    public void train(boolean success) {
        this.train(success, 1);
    }

    @Override
    public double successProbability() {
        return (double)this.mSuccessCount / (double)this.mTotalCount;
    }

    public long numTrainingSamples() {
        return this.mTotalCount;
    }

    public long numTrainingSamples(boolean success) {
        return success ? this.mSuccessCount : this.mTotalCount - this.mSuccessCount;
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -3979523774865702910L;
        final BernoulliEstimator mDistro;

        public Externalizer() {
            this.mDistro = null;
        }

        public Externalizer(BernoulliEstimator distro) {
            this.mDistro = distro;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.mDistro.successProbability());
        }

        @Override
        public Object read(ObjectInput in) throws IOException {
            double successProb = in.readDouble();
            return new BernoulliConstant(successProb);
        }
    }
}

