/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.util.Distance;
import com.aliasi.util.Proximity;
import java.util.Arrays;

public class JaroWinklerDistance
implements Distance<CharSequence>,
Proximity<CharSequence> {
    private final double mWeightThreshold;
    private final int mNumChars;
    public static final JaroWinklerDistance JARO_DISTANCE = new JaroWinklerDistance();
    public static final JaroWinklerDistance JARO_WINKLER_DISTANCE = new JaroWinklerDistance(0.7, 4);

    public JaroWinklerDistance() {
        this(Double.POSITIVE_INFINITY, 0);
    }

    public JaroWinklerDistance(double weightThreshold, int numChars) {
        this.mNumChars = numChars;
        this.mWeightThreshold = weightThreshold;
    }

    @Override
    public double distance(CharSequence cSeq1, CharSequence cSeq2) {
        return 1.0 - this.proximity(cSeq1, cSeq2);
    }

    @Override
    public double proximity(CharSequence cSeq1, CharSequence cSeq2) {
        int pos;
        int len1 = cSeq1.length();
        int len2 = cSeq2.length();
        if (len1 == 0) {
            return len2 == 0 ? 1.0 : 0.0;
        }
        int searchRange = Math.max(0, Math.max(len1, len2) / 2 - 1);
        boolean[] matched1 = new boolean[len1];
        Arrays.fill(matched1, false);
        boolean[] matched2 = new boolean[len2];
        Arrays.fill(matched2, false);
        int numCommon = 0;
        block0: for (int i = 0; i < len1; ++i) {
            int start = Math.max(0, i - searchRange);
            int end = Math.min(i + searchRange + 1, len2);
            for (int j = start; j < end; ++j) {
                if (matched2[j] || cSeq1.charAt(i) != cSeq2.charAt(j)) continue;
                matched1[i] = true;
                matched2[j] = true;
                ++numCommon;
                continue block0;
            }
        }
        if (numCommon == 0) {
            return 0.0;
        }
        int numHalfTransposed = 0;
        int j = 0;
        for (int i = 0; i < len1; ++i) {
            if (!matched1[i]) continue;
            while (!matched2[j]) {
                ++j;
            }
            if (cSeq1.charAt(i) != cSeq2.charAt(j)) {
                ++numHalfTransposed;
            }
            ++j;
        }
        double numCommonD = numCommon;
        int numTransposed = numHalfTransposed / 2;
        double weight = (numCommonD / (double)len1 + numCommonD / (double)len2 + (double)(numCommon - numTransposed) / numCommonD) / 3.0;
        if (weight <= this.mWeightThreshold) {
            return weight;
        }
        int max = Math.min(this.mNumChars, Math.min(cSeq1.length(), cSeq2.length()));
        for (pos = 0; pos < max && cSeq1.charAt(pos) == cSeq2.charAt(pos); ++pos) {
        }
        if (pos == 0) {
            return weight;
        }
        return weight + 0.1 * (double)pos * (1.0 - weight);
    }
}

