/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.KernelFunction;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class PolynomialKernel
implements KernelFunction,
Serializable {
    static final long serialVersionUID = 2807317510032521328L;
    private final int mDegree;

    public PolynomialKernel(int degree) {
        this.mDegree = degree;
    }

    @Override
    public double proximity(Vector v1, Vector v2) {
        return this.power(1.0 + v1.dotProduct(v2));
    }

    double power(double base) {
        switch (this.mDegree) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return base;
            }
            case 2: {
                return base * base;
            }
            case 3: {
                return base * base * base;
            }
            case 4: {
                return base * base * base * base;
            }
        }
        return Math.pow(base, this.mDegree);
    }

    public String toString() {
        return "PolynomialKernel(" + this.mDegree + ")";
    }

    Object writeReplace() {
        return new Externalizer(this.mDegree);
    }

    static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = 4795059467534365487L;
        final int mDegree;

        public Externalizer() {
            this(-1);
        }

        public Externalizer(int degree) {
            this.mDegree = degree;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.mDegree);
        }

        @Override
        public Object read(ObjectInput in) throws IOException {
            int degree = in.readInt();
            return new PolynomialKernel(degree);
        }
    }
}

