/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractVector;
import com.aliasi.matrix.Matrices;
import com.aliasi.matrix.Matrix;
import com.aliasi.matrix.Vector;

abstract class MatrixBackedVector
extends AbstractVector {
    protected final Matrix mMatrix;
    protected final int mIndex;

    MatrixBackedVector(Matrix m, int index) {
        this.mMatrix = m;
        this.mIndex = index;
    }

    static class Column
    extends MatrixBackedVector
    implements Vector {
        Column(Matrix m, int index) {
            super(m, index);
        }

        @Override
        public int numDimensions() {
            return this.mMatrix.numRows();
        }

        @Override
        public void setValue(int row, double value) {
            this.mMatrix.setValue(row, this.mIndex, value);
        }

        @Override
        public double value(int row) {
            return this.mMatrix.value(row, this.mIndex);
        }

        @Override
        public Vector add(Vector v) {
            return Matrices.add(this, v);
        }
    }

    static class Row
    extends MatrixBackedVector
    implements Vector {
        Row(Matrix m, int index) {
            super(m, index);
        }

        @Override
        public int numDimensions() {
            return this.mMatrix.numColumns();
        }

        @Override
        public void setValue(int column, double value) {
            this.mMatrix.setValue(this.mIndex, column, value);
        }

        @Override
        public double value(int column) {
            return this.mMatrix.value(this.mIndex, column);
        }

        @Override
        public Vector add(Vector v) {
            return Matrices.add(this, v);
        }
    }
}

