/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.DeletingTrieReader;
import com.aliasi.lm.TrieReader;
import java.io.IOException;

public class ScaleTrieReader
extends DeletingTrieReader {
    private final double mScale;

    public ScaleTrieReader(TrieReader reader, double scale) throws IOException {
        super(reader);
        if (scale <= 0.0 || Double.isNaN(scale) || Double.isInfinite(scale)) {
            String msg = "Scale must be positive and non-infinite. Found scale=" + scale;
            throw new IllegalArgumentException(msg);
        }
        this.mScale = scale;
    }

    @Override
    boolean bufferCount() throws IOException {
        this.mNextCount = Math.round(this.mScale * (double)this.nextCount());
        return this.mNextCount > 0L;
    }
}

