/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.features.ModifiedFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class BoundedFeatureExtractor<E>
extends ModifiedFeatureExtractor<E>
implements Serializable {
    static final long serialVersionUID = -5628628360712035433L;
    private final double mMinValue;
    private final double mMaxValue;
    private final Number mMinValueNumber;
    private final Number mMaxValueNumber;

    public BoundedFeatureExtractor(FeatureExtractor<? super E> extractor, double minValue, double maxValue) {
        super(extractor);
        if (minValue > maxValue) {
            String msg = "Require minValue <= maxValue. Found  minValue=" + minValue + " maxValue=" + maxValue;
            throw new IllegalArgumentException(msg);
        }
        this.mMinValue = minValue;
        this.mMaxValue = maxValue;
        this.mMinValueNumber = minValue;
        this.mMaxValueNumber = maxValue;
    }

    @Override
    public Number filter(String feature, Number value) {
        double v = value.doubleValue();
        if (v < this.mMinValue) {
            return this.mMinValueNumber;
        }
        if (v > this.mMaxValue) {
            return this.mMaxValueNumber;
        }
        return value;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 6365515337527915147L;
        private final BoundedFeatureExtractor<F> mBFExtractor;

        public Serializer() {
            this(null);
        }

        public Serializer(BoundedFeatureExtractor<F> extractor) {
            this.mBFExtractor = extractor;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(((BoundedFeatureExtractor)this.mBFExtractor).mMinValue);
            out.writeDouble(((BoundedFeatureExtractor)this.mBFExtractor).mMaxValue);
            out.writeObject(this.mBFExtractor.baseExtractor());
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            double minValue = in.readDouble();
            double maxValue = in.readDouble();
            FeatureExtractor extractor = (FeatureExtractor)in.readObject();
            return new BoundedFeatureExtractor(extractor, minValue, maxValue);
        }
    }
}

