/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref.matchers;

import com.aliasi.coref.BooleanMatcherAdapter;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import com.aliasi.util.ObjectToSet;
import java.util.Set;

public class SynonymMatch
extends BooleanMatcherAdapter {
    private final ObjectToSet<String, String> mSynonymDictionary = new ObjectToSet();

    public SynonymMatch(int score) {
        super(score);
    }

    @Override
    public boolean matchBoolean(Mention mention, MentionChain chain) {
        String phrase = mention.normalPhrase();
        if (!this.mSynonymDictionary.containsKey(phrase)) {
            return false;
        }
        Set<String> synonyms = this.mSynonymDictionary.getSet(phrase);
        for (String synonym : synonyms) {
            for (Mention chainMention : chain.mentions()) {
                if (!synonym.equals(chainMention.normalPhrase())) continue;
                return true;
            }
        }
        return false;
    }

    public void addSynonym(String phrase1, String phrase2) {
        this.mSynonymDictionary.addMember(phrase1, phrase2);
        this.mSynonymDictionary.addMember(phrase2, phrase1);
    }

    public void removeSynonym(String phrase1, String phrase2) {
        this.mSynonymDictionary.removeMember(phrase1, phrase2);
        this.mSynonymDictionary.removeMember(phrase2, phrase1);
    }

    public void clearSynonyms() {
        this.mSynonymDictionary.clear();
    }
}

