/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.AbstractMentionChain;
import com.aliasi.coref.Killer;
import com.aliasi.coref.Matcher;
import com.aliasi.coref.Mention;
import com.aliasi.coref.Tags;
import com.aliasi.coref.matchers.EntityTypeMatch;
import com.aliasi.coref.matchers.ExactPhraseMatch;
import com.aliasi.coref.matchers.GenderKiller;
import com.aliasi.coref.matchers.HonorificConflictKiller;
import com.aliasi.coref.matchers.SequenceSubstringMatch;
import com.aliasi.coref.matchers.SynonymMatch;

public class MentionChainImpl
extends AbstractMentionChain {
    private int mMatcherDescriptor;
    private static final int MALE_OR_FEMALE_MATCHERS = 0;
    private static final int THING_MATCHERS = 1;
    private static final int MALE_PRONOUN_MATCHERS = 2;
    private static final int FEMALE_PRONOUN_MATCHERS = 3;
    private static final int MALE_MATCHERS = 4;
    private static final int FEMALE_MATCHERS = 5;
    private static final int[][] UNIFIER = new int[6][6];
    private static final Matcher[][] MATCHERS;
    private static final Killer[][] KILLERS;

    public MentionChainImpl(Mention mention, int offset, int id) {
        super(mention, offset, id);
        this.mMatcherDescriptor = MentionChainImpl.typeToMatcherDescriptor(mention.entityType());
    }

    @Override
    public Matcher[] matchers() {
        if (this.mMatcherDescriptor < 0) {
            return MATCHERS[1];
        }
        return MATCHERS[this.mMatcherDescriptor];
    }

    @Override
    public Killer[] killers() {
        if (this.mMatcherDescriptor < 0) {
            return KILLERS[1];
        }
        return KILLERS[this.mMatcherDescriptor];
    }

    @Override
    protected void add(Mention mention) {
        int typeToMatchIndex = MentionChainImpl.typeToMatcherDescriptor(mention.entityType());
        if (this.mMatcherDescriptor >= 0 && typeToMatchIndex >= 0) {
            this.mMatcherDescriptor = UNIFIER[this.mMatcherDescriptor][typeToMatchIndex];
        }
        if (this.gender() == null && mention.gender() != null) {
            this.setGender(mention.gender());
        }
        for (String honorific : mention.honorifics()) {
            this.addHonorific(honorific);
        }
    }

    private static int typeToMatcherDescriptor(String entityType) {
        if (entityType.equals(Tags.PERSON_TAG)) {
            return 0;
        }
        if (entityType.equals(Tags.LOCATION_TAG)) {
            return 1;
        }
        if (entityType.equals(Tags.ORGANIZATION_TAG)) {
            return 1;
        }
        if (entityType.equals(Tags.MALE_PRONOUN_TAG)) {
            return 2;
        }
        if (entityType.equals(Tags.FEMALE_PRONOUN_TAG)) {
            return 3;
        }
        return -1;
    }

    private static final void descriptor(int descriptor) {
        MentionChainImpl.subsume(descriptor, descriptor);
    }

    private static void subsume(int descriptorLess, int descriptorMore) {
        MentionChainImpl.unify(descriptorLess, descriptorMore, descriptorMore);
    }

    private static void unify(int descriptor1, int descriptor2, int result) {
        MentionChainImpl.UNIFIER[descriptor1][descriptor2] = result;
        MentionChainImpl.UNIFIER[descriptor2][descriptor1] = result;
    }

    static {
        MentionChainImpl.descriptor(0);
        MentionChainImpl.descriptor(1);
        MentionChainImpl.descriptor(2);
        MentionChainImpl.descriptor(3);
        MentionChainImpl.descriptor(4);
        MentionChainImpl.descriptor(5);
        MentionChainImpl.subsume(2, 4);
        MentionChainImpl.subsume(3, 5);
        MentionChainImpl.subsume(0, 4);
        MentionChainImpl.subsume(0, 5);
        MentionChainImpl.unify(0, 2, 4);
        MentionChainImpl.unify(0, 3, 5);
        MATCHERS = new Matcher[6][];
        MentionChainImpl.MATCHERS[0] = new Matcher[]{new ExactPhraseMatch(1), new EntityTypeMatch(3, Tags.MALE_PRONOUN_TAG), new EntityTypeMatch(3, Tags.FEMALE_PRONOUN_TAG), new SequenceSubstringMatch(3), new SynonymMatch(1)};
        MentionChainImpl.MATCHERS[1] = new Matcher[]{new ExactPhraseMatch(1), new SequenceSubstringMatch(3), new SynonymMatch(1)};
        MentionChainImpl.MATCHERS[2] = new Matcher[]{new EntityTypeMatch(1, Tags.MALE_PRONOUN_TAG)};
        MentionChainImpl.MATCHERS[3] = new Matcher[]{new EntityTypeMatch(1, Tags.FEMALE_PRONOUN_TAG)};
        MentionChainImpl.MATCHERS[4] = new Matcher[]{new ExactPhraseMatch(1), new EntityTypeMatch(1, Tags.MALE_PRONOUN_TAG), new SequenceSubstringMatch(3), new SynonymMatch(1)};
        MentionChainImpl.MATCHERS[5] = new Matcher[]{new ExactPhraseMatch(1), new EntityTypeMatch(1, Tags.FEMALE_PRONOUN_TAG), new SequenceSubstringMatch(3), new SynonymMatch(1)};
        KILLERS = new Killer[6][];
        MentionChainImpl.KILLERS[0] = new Killer[]{new GenderKiller(), new HonorificConflictKiller()};
        MentionChainImpl.KILLERS[1] = new Killer[]{new GenderKiller()};
        MentionChainImpl.KILLERS[2] = new Killer[]{new GenderKiller()};
        MentionChainImpl.KILLERS[3] = new Killer[]{new GenderKiller()};
        MentionChainImpl.KILLERS[4] = new Killer[]{new GenderKiller(), new HonorificConflictKiller()};
        MentionChainImpl.KILLERS[5] = new Killer[]{new GenderKiller(), new HonorificConflictKiller()};
    }
}

