/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.AbstractMentionFactory;
import com.aliasi.coref.Tags;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.util.Strings;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class EnglishMentionFactory
extends AbstractMentionFactory {
    public static final String MALE_GENDER = "male";
    public static final String FEMALE_GENDER = "female";
    public static final String NEUTER_GENDER = "neuter";
    public static final Set<String> MALE_HONORIFICS = new HashSet<String>();
    public static final Set<String> FEMALE_HONORIFICS;
    public static final Set<String> HONORIFICS;

    public EnglishMentionFactory() {
        super(IndoEuropeanTokenizerFactory.INSTANCE);
    }

    @Override
    public boolean isHonorific(String normalizedToken) {
        return HONORIFICS.contains(normalizedToken);
    }

    @Override
    public boolean isPronominal(String entityType) {
        return entityType.equals(Tags.MALE_PRONOUN_TAG) || entityType.equals(Tags.FEMALE_PRONOUN_TAG) || entityType.equals(Tags.NEUTER_PRONOUN_TAG);
    }

    @Override
    public String normalizeToken(String token) {
        if (Strings.allPunctuation(token)) {
            return null;
        }
        return token.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String gender(String entityType) {
        if (entityType.equals(Tags.MALE_PRONOUN_TAG)) {
            return MALE_GENDER;
        }
        if (entityType.equals(Tags.FEMALE_PRONOUN_TAG)) {
            return FEMALE_GENDER;
        }
        if (entityType.equals(Tags.PERSON_TAG)) {
            return null;
        }
        return NEUTER_GENDER;
    }

    static {
        MALE_HONORIFICS.add("mr");
        MALE_HONORIFICS.add("mssr");
        MALE_HONORIFICS.add("mister");
        FEMALE_HONORIFICS = new HashSet<String>();
        FEMALE_HONORIFICS.add("ms");
        FEMALE_HONORIFICS.add("mrs");
        FEMALE_HONORIFICS.add("missus");
        FEMALE_HONORIFICS.add("miss");
        HONORIFICS = new HashSet<String>();
        HONORIFICS.addAll(MALE_HONORIFICS);
        HONORIFICS.addAll(FEMALE_HONORIFICS);
        HONORIFICS.add("dr");
        HONORIFICS.add("gen");
        HONORIFICS.add("adm");
        HONORIFICS.add("pres");
    }
}

