/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2PublishTable;
import com.akamai.javaquery.Q2Table;
import com.akamai.javaquery.enums.Q2AggType;
import com.akamai.javaquery.enums.Q2DataType;
import com.akamai.javaquery.exceptions.Q2InvalidColumnException;
import com.akamai.javaquery.exceptions.Q2TypeException;
import com.akamai.javaquery.sqlWrappers.ResultSetMetaDataWrapper;
import java.util.Hashtable;
import java.util.Map;

public final class Q2TableMetaData
extends ResultSetMetaDataWrapper {
    private int numCols;
    private boolean[] columnSet;
    private final String name;
    private Q2ColumnMetadata[] columns;
    private final String description;
    private Q2Table table;
    private Map<String, Integer> nameToIndex = new Hashtable<String, Integer>();
    private final boolean publishing;
    private long columnPtr;
    private boolean tableSet;

    Q2TableMetaData(Q2Table table) {
        this.publishing = false;
        this.table = table;
        this.numCols = this.get_num_columns(table.getTablePtr());
        this.columns = new Q2ColumnMetadata[this.numCols];
        this.name = this.get_table_name(table.getTablePtr());
        this.description = null;
        this.makeMapNameToIndex();
        this.tableSet = true;
    }

    public Q2TableMetaData(String name, String description, int numCols) {
        if (name == null || description == null) {
            throw new NullPointerException("Metadata name and / or description can't be null");
        }
        if (numCols < 0) {
            throw new ArithmeticException("Number of columns must be non-negative");
        }
        this.publishing = true;
        this.name = name;
        this.description = description;
        this.numCols = numCols;
        this.columnPtr = this.column_malloc(numCols);
        this.columnSet = new boolean[numCols];
        this.columns = new Q2ColumnMetadata[numCols];
    }

    public void insertColumn(int columnIndex, String name, String description, Q2DataType datatype, Q2AggType aggtype, boolean nullable, boolean mergeable) {
        if (!this.publishing) {
            throw new IllegalStateException("This method is only for publishing");
        }
        if (columnIndex < 1 || columnIndex > this.numCols) {
            throw new Q2InvalidColumnException();
        }
        if (this.columnSet[columnIndex - 1]) {
            throw new IllegalStateException("Column already inserted");
        }
        if (name == null || description == null || datatype == null || aggtype == null) {
            throw new NullPointerException("insertColumn parameters can't be null");
        }
        this.columns[columnIndex - 1] = new Q2ColumnMetadata(columnIndex, name, description, datatype, aggtype, nullable, mergeable);
        this.columnSet[columnIndex - 1] = true;
    }

    public int getRowCount() {
        this.checkTableSet();
        this.table.checkClosed();
        if (this.publishing) {
            ((Q2PublishTable)this.table).checkWriteable();
        }
        return this.get_num_rows(this.table.getTablePtr());
    }

    public int getColumnCount() {
        this.checkTableSet();
        this.table.checkClosed();
        return this.numCols;
    }

    public String getColumnName(int arg0) {
        this.checkColumnIndex(arg0);
        return this.getColumnMetadata(arg0).getName();
    }

    public Q2DataType getDataType(int arg0) {
        this.checkColumnIndex(arg0);
        return this.getColumnMetadata(arg0).getDatatype();
    }

    String _getName() {
        return this.name;
    }

    public String getName() {
        this.checkTableSet();
        this.table.checkClosed();
        return this._getName();
    }

    public int isNullable(int arg0) {
        this.checkColumnIndex(arg0);
        boolean nullable = this.getColumnMetadata(arg0).isNullable();
        if (nullable) {
            return 1;
        }
        return 0;
    }

    public boolean isMerged(int arg0) {
        this.checkColumnIndex(arg0);
        return this.getColumnMetadata(arg0).isMerged();
    }

    public Q2AggType getAggType(int arg0) {
        this.checkColumnIndex(arg0);
        return this.getColumnMetadata(arg0).getAggtype();
    }

    public String getColumnDescription(int arg0) {
        this.checkColumnIndex(arg0);
        return this.getColumnMetadata(arg0).getDescription();
    }

    String getDescription() {
        return this.description;
    }

    String findColumnName(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        String name = this.getColumnMetadata(columnIndex).getName();
        return name;
    }

    int findColumn(String columnName) {
        this.table.checkClosed();
        this.checkTableSet();
        Integer index = this.nameToIndex.get(columnName);
        if (index == null) {
            throw new Q2InvalidColumnException();
        }
        return index;
    }

    void checkColumnIndexAndDataType(int col, Q2DataType datatype) {
        this.checkColumnIndex(col);
        if (datatype != this.getDataType(col)) {
            throw new Q2TypeException();
        }
    }

    void checkColumnIndex(int col) {
        this.checkTableSet();
        this.table.checkClosed();
        if (col < 1 || col > this.numCols) {
            throw new Q2InvalidColumnException();
        }
    }

    void checkTableSet() {
        if (!this.tableSet) {
            throw new IllegalStateException("Must insert all columns first before accessing them");
        }
    }

    void setTable(Q2Table table) {
        if (this.table != null) {
            throw new IllegalStateException("TableMetaData already associated with another Table");
        }
        for (boolean b : this.columnSet) {
            if (b) continue;
            throw new IllegalStateException("Must set all columns before publishing");
        }
        this.makeMapNameToIndex();
        this.table = table;
        this.tableSet = true;
    }

    void unsetTable() {
        this.table = null;
        this.tableSet = false;
    }

    long getColumnPtr() {
        return this.columnPtr;
    }

    int[] getDatatypes() {
        int[] datatypes = new int[this.numCols];
        for (int d = 0; d < this.numCols; ++d) {
            datatypes[d] = this.getDataType(d + 1).getCode();
        }
        return datatypes;
    }

    private void makeMapNameToIndex() {
        for (int index = 1; index <= this.numCols; ++index) {
            if (!this.publishing) {
                this.columns[index - 1] = new Q2ColumnMetadata(index);
            }
            String name = this.getColumnMetadata(index).getName();
            this.nameToIndex.put(name, index);
        }
    }

    private Q2ColumnMetadata getColumnMetadata(int columnIndex) {
        return this.columns[columnIndex - 1];
    }

    private native String get_column_name(long var1, int var3);

    private native String get_column_description(long var1, int var3);

    private native int get_data_type(long var1, int var3);

    private native int get_aggregation_type(long var1, int var3);

    private native boolean is_nullable(long var1, int var3);

    private native boolean is_mergeable(long var1, int var3);

    private native int get_num_rows(long var1);

    private native int get_num_columns(long var1);

    private native String get_table_name(long var1);

    private native long column_malloc(int var1);

    private native void add_column(long var1, int var3, String var4, String var5, int var6, int var7, boolean var8, boolean var9);

    static {
        System.loadLibrary("javaquery");
    }

    final class Q2ColumnMetadata {
        private final String name;
        private final Q2DataType datatype;
        private final int index;
        private Q2Table table;
        private String description;
        private boolean nullable;
        private boolean mergeable;
        private Q2AggType aggtype;

        Q2ColumnMetadata(int columnIndex, String name, String description, Q2DataType datatype, Q2AggType aggtype, boolean nullable, boolean mergeable) {
            this.name = name;
            this.description = description;
            this.index = columnIndex;
            this.datatype = datatype;
            this.aggtype = aggtype;
            this.nullable = nullable;
            this.mergeable = mergeable;
            Q2TableMetaData.this.add_column(Q2TableMetaData.this.columnPtr, this.index, name, description, datatype.getCode(), aggtype.getCode(), nullable, mergeable);
        }

        Q2ColumnMetadata(int columnIndex) {
            this.table = Q2TableMetaData.this.table;
            this.index = columnIndex;
            int dataVal = Q2TableMetaData.this.get_data_type(this.table.getTablePtr(), this.index);
            this.datatype = Q2DataType.get(dataVal);
            this.name = Q2TableMetaData.this.get_column_name(this.table.getTablePtr(), this.index);
            this.aggtype = Q2AggType.get(Q2TableMetaData.this.get_aggregation_type(this.table.getTablePtr(), this.index));
            this.description = Q2TableMetaData.this.get_column_description(this.table.getTablePtr(), this.index);
            this.nullable = Q2TableMetaData.this.is_nullable(this.table.getTablePtr(), this.index);
            this.mergeable = Q2TableMetaData.this.is_mergeable(this.table.getTablePtr(), this.index);
        }

        Q2AggType getAggtype() {
            return this.aggtype;
        }

        String getName() {
            return this.name;
        }

        String getDescription() {
            return this.description;
        }

        boolean isNullable() {
            return this.nullable;
        }

        boolean isMerged() {
            return this.mergeable;
        }

        int getIndex() {
            return this.index;
        }

        Q2DataType getDatatype() {
            return this.datatype;
        }
    }
}

