/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2Connection;
import com.akamai.javaquery.Q2Future;
import com.akamai.javaquery.Q2PublishCallback;
import com.akamai.javaquery.Q2PublishTable;
import com.akamai.javaquery.Q2QueryCallback;
import com.akamai.javaquery.Q2ResultTable;
import com.akamai.javaquery.Q2TableMetaData;
import com.akamai.javaquery.exceptions.Q2PublishException;
import com.akamai.javaquery.exceptions.Q2QueryException;
import com.akamai.javaquery.sqlWrappers.StatementWrapper;
import java.util.concurrent.ExecutionException;

public final class Q2Statement
extends StatementWrapper {
    private final Q2Connection conn;

    Q2Statement(Q2Connection conn) {
        this.conn = conn;
    }

    public Q2ResultTable executeQuery(String sql) throws Q2QueryException {
        return this.executeQuery(sql, false);
    }

    private Q2ResultTable executeQuery(String sql, boolean ddl) throws Q2QueryException {
        try {
            return new Q2Future(sql, ddl, this).get();
        }
        catch (ExecutionException e) {
            throw (Q2QueryException)e.getCause();
        }
    }

    public Q2Future executeQueryAsync(String sql) throws Q2QueryException {
        return new Q2Future(sql, false, this);
    }

    public Q2Future executeQueryAsync(String sql, Q2QueryCallback qcb) throws Q2QueryException {
        return new Q2Future(sql, false, this, qcb);
    }

    public String executeCommand(String sql) throws Q2QueryException {
        Q2ResultTable rt = this.executeQuery(sql, true);
        return rt.getInfoString();
    }

    public void executePublish(Q2PublishTable pt) throws Q2PublishException {
        this.conn.checkClosed();
        this.checkIsPublishing(true);
        if (pt == null) {
            throw new NullPointerException("Q2PublishTable can't be null");
        }
        if (!pt.isSynchronous()) {
            throw new IllegalStateException("Can't syncronously publish a table that is or was published asynchronously");
        }
        int status = this.publish_synchronous(this.conn.getConnPtr(), pt.getTablePtr());
        Q2Statement.checkStatus(status);
    }

    public void executePublishAsync(Q2TableMetaData tmd, Q2PublishCallback callback) throws Q2PublishException {
        this.conn.checkClosed();
        this.checkIsPublishing(true);
        if (tmd == null || callback == null) {
            throw new NullPointerException("Parameters to executePublishAsync can't be null");
        }
        callback.setup(tmd, this);
        int status = this.publish(tmd._getName(), tmd.getDescription(), tmd.getColumnPtr(), this.conn.getConnPtr(), callback.getArgsPtr());
        if (status != 0) {
            callback.takeDown();
            if (status == -1) {
                throw new Q2PublishException("User Error");
            }
            if (status == -2) {
                throw new Q2PublishException("No memory");
            }
        }
    }

    public void executeUnpublish(Q2PublishTable pt) throws Q2PublishException {
        this.conn.checkClosed();
        this.checkIsPublishing(true);
        if (pt == null) {
            throw new NullPointerException("PublishTable can't be null");
        }
        if (pt.isClosed()) {
            throw new IllegalStateException("PublishTable is closed");
        }
        if (!pt.isSynchronous()) {
            throw new IllegalStateException("Can't syncronously unpublish a table that is or was published asynchronously");
        }
        this.conn.checkClosed();
        int status = this.unpublish(this.conn.getConnPtr(), pt.getMetaData().getName());
        Q2Statement.checkStatus(status);
    }

    public void executeUnpublishAsync(Q2PublishCallback callback) throws Q2PublishException {
        this.conn.checkClosed();
        this.checkIsPublishing(true);
        if (callback == null) {
            throw new NullPointerException("Q2Callback can't be null");
        }
        String name = callback.getTableMetaData().getName();
        int status = this.unpublish(this.conn.getConnPtr(), name);
        callback.takeDown();
        Q2Statement.checkStatus(status);
    }

    public Q2Connection getConnection() {
        return this.conn;
    }

    static void checkStatus(int status) throws Q2PublishException {
        switch (status) {
            case -2: {
                throw new Q2PublishException("User Error");
            }
            case -1: {
                throw new Q2PublishException("No memory");
            }
        }
    }

    void checkIsPublishing(boolean publishing) {
        if (publishing != this.conn.isPublishing()) {
            throw new IllegalStateException("Can only publish on publishing connection and can only query on non-publishing connection");
        }
    }

    static native int issue_query_async(long var0, String var2, long var3);

    private native int unpublish(long var1, String var3);

    private native int publish_synchronous(long var1, long var3);

    private native int publish(String var1, String var2, long var3, long var5, long var7);

    static native long make_global_ref(Object var0);

    static native void delete_global_ref(long var0);
}

