/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2Statement;
import com.akamai.javaquery.Q2Table;
import com.akamai.javaquery.Q2TableMetaData;
import com.akamai.javaquery.enums.Q2DataType;
import com.akamai.javaquery.exceptions.Q2InvalidRowException;
import com.akamai.javaquery.exceptions.Q2QueryException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Date;

public final class Q2ResultTable
extends Q2Table {
    private int cursor;
    private final long resultTablePtr;
    private Q2Statement stmnt;

    Q2ResultTable(long resultTablePtr, Q2Statement stmnt, boolean ddl) throws Q2QueryException {
        this.resultTablePtr = resultTablePtr;
        if (resultTablePtr == 0L) {
            throw new Q2QueryException("Query failed");
        }
        this.setTablePtr(resultTablePtr);
        this.stmnt = stmnt;
        if (this.isErrorTable()) {
            String error = this.getErrorString();
            this.close();
            throw new Q2QueryException("Query returned with error: " + error);
        }
        if (this.isInfoTable() && !ddl) {
            this.close();
            throw new Q2QueryException("Use executeCommand(String sql) for DDL sql statements that don't return a table.");
        }
        if (!this.isInfoTable() && ddl) {
            this.close();
            throw new Q2QueryException("Use executeQuery or executeQueryAsync for sql statements that return a table.");
        }
        this.setTableMetaData(new Q2TableMetaData(this));
        this.cursor = -1;
    }

    public boolean absolute(int row) {
        if (row < 0) {
            this.cursor = this.getRowCount() + row;
            if (this.cursor < 0) {
                this.cursor = -1;
                return false;
            }
        } else {
            this.cursor = row;
            if (this.cursor >= this.getRowCount()) {
                this.cursor = this.getRowCount();
                return false;
            }
        }
        return true;
    }

    public void beforeFirst() {
        if (this.getRowCount() == 0) {
            return;
        }
        this.cursor = -1;
    }

    public void afterLast() {
        if (this.getRowCount() == 0) {
            return;
        }
        this.cursor = this.getRowCount();
    }

    public boolean first() {
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = 0;
        return true;
    }

    InetAddress getIPv4(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.IPV4);
        int ipv4Addr = this.get_cell_ipv4(this.resultTablePtr, this.cursor, columnIndex);
        if (ipv4Addr == 0) {
            return null;
        }
        byte[] ipv4Array = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(ipv4Array);
        buf.putInt(ipv4Addr);
        try {
            return InetAddress.getByAddress(ipv4Array);
        }
        catch (IOException e1) {
            throw new RuntimeException("Bad IPv4 addr in Q2ResultTable.");
        }
    }

    InetAddress getIPv6(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.IPV6);
        byte[] ipv6Addr = this.get_cell_ipv6(this.resultTablePtr, this.cursor, columnIndex);
        int sum = 0;
        for (byte b : ipv6Addr) {
            sum += b;
        }
        if (sum == 0) {
            return null;
        }
        try {
            return InetAddress.getByAddress(ipv6Addr);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Bad IPv6 addr in Q2ResultTable");
        }
    }

    public InetAddress getIP(int columnIndex) {
        if (this.getMetaData().getDataType(columnIndex) == Q2DataType.IPV6) {
            return this.getIPv6(columnIndex);
        }
        return this.getIPv4(columnIndex);
    }

    public InetAddress getIP(String columnName) {
        return this.getIP(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.DATE);
        long time = this.get_cell_time(this.resultTablePtr, this.cursor, columnIndex);
        if (time == 0L) {
            return null;
        }
        return new Date(time * 1000L);
    }

    public Date getDate(String columnName) {
        return this.getDate(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.INT);
        int n = this.get_cell_int(this.resultTablePtr, this.cursor, columnIndex);
        return n;
    }

    public int getInt(String columnName) {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.INT);
        long n = this.get_cell_long(this.resultTablePtr, this.cursor, columnIndex);
        return n;
    }

    public long getLong(String columnName) {
        return this.getLong(this.findColumn(columnName));
    }

    public String getString(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.STRING);
        String str = this.get_cell_str(this.resultTablePtr, this.cursor, columnIndex);
        return str;
    }

    public String getString(String columnName) {
        return this.getString(this.findColumn(columnName));
    }

    public float getFloat(int columnIndex) {
        this.checkBeforeGet(columnIndex, Q2DataType.FLOAT);
        float f = this.get_cell_float(this.resultTablePtr, this.cursor, columnIndex);
        return f;
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() {
        if (this.getRowCount() == 0) {
            return false;
        }
        return this.cursor == -1;
    }

    public boolean isFirst() {
        return this.cursor == 0;
    }

    public boolean isLast() {
        return this.cursor == this.getRowCount() - 1;
    }

    public boolean isAfterLast() {
        if (this.getRowCount() == 0) {
            return false;
        }
        return this.cursor == this.getRowCount();
    }

    public boolean last() {
        if (this.getRowCount() < 1) {
            return false;
        }
        this.cursor = this.getRowCount() - 1;
        return true;
    }

    public boolean next() {
        if (this.cursor >= this.getRowCount() - 1) {
            this.cursor = this.getRowCount();
            return false;
        }
        ++this.cursor;
        return true;
    }

    public boolean previous() {
        if (this.cursor <= 0) {
            this.cursor = -1;
            return false;
        }
        --this.cursor;
        return true;
    }

    public boolean relative(int rows) {
        this.cursor += rows;
        if (this.cursor < 0) {
            this.cursor = -1;
            return false;
        }
        if (this.cursor >= this.getRowCount()) {
            this.cursor = this.getRowCount();
            return false;
        }
        return true;
    }

    public boolean wasRedirected() {
        if (this.isClosed()) {
            throw new IllegalStateException("Q2Table has been freed.");
        }
        return this.was_redirected(this.resultTablePtr);
    }

    public int getRow() {
        return this.cursor;
    }

    private native int get_cell_int(long var1, long var3, long var5);

    private native long get_cell_long(long var1, long var3, long var5);

    private native long get_cell_time(long var1, long var3, long var5);

    private native int get_cell_ipv4(long var1, long var3, long var5);

    private native float get_cell_float(long var1, long var3, long var5);

    private native String get_cell_str(long var1, long var3, long var5);

    private native byte[] get_cell_ipv6(long var1, long var3, long var5);

    private native boolean was_redirected(long var1);

    private native boolean is_error_table(long var1);

    private native String get_error_string(long var1);

    private native String get_info_string(long var1);

    private native boolean is_info_table(long var1);

    boolean isErrorTable() {
        this.checkClosed();
        return this.is_error_table(this.resultTablePtr);
    }

    boolean isInfoTable() {
        this.checkClosed();
        return this.is_info_table(this.resultTablePtr);
    }

    String getErrorString() {
        this.checkClosed();
        return this.get_error_string(this.resultTablePtr);
    }

    String getInfoString() {
        this.checkClosed();
        return this.get_info_string(this.resultTablePtr);
    }

    private void checkBeforeGet(int columnIndex, Q2DataType datatype) {
        this.checkClosed();
        this.getMetaData().checkColumnIndexAndDataType(columnIndex, datatype);
        if (this.cursor <= -1) {
            throw new Q2InvalidRowException("Can't access column. Cursor is before first.");
        }
        if (this.cursor >= this.getRowCount()) {
            throw new Q2InvalidRowException("Can't access column. Cursor is after last.");
        }
    }

    private int getRowCount() {
        return this.getMetaData().getRowCount();
    }

    public Q2Statement getStatement() {
        if (this.stmnt == null) {
            throw new NullPointerException("Statement is null");
        }
        return this.stmnt;
    }

    public void close() {
        super.close();
    }
}

