/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2Statement;
import com.akamai.javaquery.Q2Table;
import com.akamai.javaquery.Q2TableMetaData;
import com.akamai.javaquery.enums.Q2DataType;
import com.akamai.javaquery.exceptions.Q2PublishException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.ByteBuffer;
import java.sql.Date;

public class Q2PublishTable
extends Q2Table {
    private long rowPtr;
    private boolean writeable;
    private boolean synchronous;

    Q2PublishTable(Q2TableMetaData tableMetaData, boolean synchronous) {
        if (tableMetaData == null) {
            throw new NullPointerException("Table metadata can't be null.");
        }
        this.synchronous = synchronous;
        this.writeable = synchronous;
        tableMetaData.setTable(this);
        this.setTableMetaData(tableMetaData);
        this.rowPtr = this.create_row(this.getMetaData().getDatatypes());
    }

    public Q2PublishTable(Q2TableMetaData tableMetaData) {
        this(tableMetaData, true);
        this.setTablePtr(this.create_table(tableMetaData.getName(), tableMetaData.getDescription(), tableMetaData.getColumnPtr()));
    }

    public void clear() {
        this.checkClosed();
        this.checkWriteable();
        this.clear_table(this.getTablePtr());
    }

    public void insertRow() throws Q2PublishException {
        this.checkClosed();
        this.checkWriteable();
        int status = this.add_row(this.getTablePtr(), this.rowPtr);
        Q2Statement.checkStatus(status);
    }

    private native void insert_int(long var1, int var3, int var4);

    private native void insert_long(long var1, int var3, long var4);

    private native void insert_float(long var1, int var3, float var4);

    private native void insert_str(long var1, int var3, String var4);

    private native void insert_date(long var1, int var3, long var4);

    private native void insert_ipv4(long var1, int var3, int var4);

    private native void insert_ipv6(long var1, int var3, byte[] var4);

    private native int add_row(long var1, long var3);

    private native void clear_table(long var1);

    private native long create_table(String var1, String var2, long var3);

    private native long create_row(int[] var1);

    private native void free_row(int var1, long var2);

    public void updateIPv4(int columnIndex, Inet4Address data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.IPV4);
        if (data == null) {
            return;
        }
        byte[] ipv4Array = data.getAddress();
        ByteBuffer buf = ByteBuffer.wrap(ipv4Array);
        this.insert_ipv4(this.rowPtr, columnIndex, buf.getInt());
    }

    public void updateIPv4(String columnName, Inet4Address data) {
        this.updateIPv4(this.findColumn(columnName), data);
    }

    public void updateIPv6(int columnIndex, Inet6Address data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.IPV6);
        if (data == null) {
            return;
        }
        this.insert_ipv6(this.rowPtr, columnIndex, data.getAddress());
    }

    public void updateIPv6(String columnName, Inet6Address data) {
        this.updateIPv6(this.findColumn(columnName), data);
    }

    public void updateDate(int columnIndex, Date data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.DATE);
        if (data == null) {
            return;
        }
        this.insert_date(this.rowPtr, columnIndex, data.getTime() / 1000L);
    }

    public void updateDate(String columnName, Date data) {
        this.updateDate(this.findColumn(columnName), data);
    }

    public void updateInt(int columnIndex, int data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.INT);
        this.insert_int(this.rowPtr, columnIndex, data);
    }

    public void updateInt(String columnName, int data) {
        this.updateInt(this.findColumn(columnName), data);
    }

    public void updateLong(int columnIndex, long data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.INT);
        this.insert_long(this.rowPtr, columnIndex, data);
    }

    public void updateLong(String columnName, long data) {
        this.updateLong(this.findColumn(columnName), data);
    }

    public void updateString(int columnIndex, String data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.STRING);
        if (data == null) {
            return;
        }
        this.insert_str(this.rowPtr, columnIndex, data);
    }

    public void updateString(String columnName, String data) {
        this.updateString(this.findColumn(columnName), data);
    }

    public void updateFloat(int columnIndex, float data) {
        this.checkBeforeUpdate(columnIndex, Q2DataType.FLOAT);
        this.insert_float(this.rowPtr, columnIndex, data);
    }

    public void updateFloat(String columnName, float data) {
        this.updateFloat(this.findColumn(columnName), data);
    }

    void checkBeforeUpdate(int columnIndex, Q2DataType datatype) {
        this.checkClosed();
        this.checkWriteable();
        this.getMetaData().checkColumnIndexAndDataType(columnIndex, datatype);
    }

    void checkWriteable() {
        if (!this.writeable) {
            throw new IllegalStateException();
        }
    }

    void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    boolean isSynchronous() {
        return this.synchronous;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        if (this.rowPtr != 0L) {
            this.free_row(this.getMetaData().getColumnCount(), this.rowPtr);
            this.rowPtr = 0L;
        }
        if (this.synchronous) {
            super.close();
        } else {
            this.setCloseJavaOnly();
        }
    }
}

