/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.javaquery;

import com.akamai.javaquery.Q2PublishTable;
import com.akamai.javaquery.Q2Statement;
import com.akamai.javaquery.Q2TableMetaData;
import java.util.concurrent.atomic.AtomicBoolean;

public class Q2PublishCallback
implements Runnable {
    private Q2TableMetaData tmd;
    private Q2PublishTable pt;
    private long argsPtr;
    private Q2Statement stmnt;
    private final Object lock = new Object();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setup(Q2TableMetaData tmd, Q2Statement stmnt) {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized.get()) {
                throw new IllegalStateException("This callback is already being used for an asynchronous publish");
            }
            this.stmnt = stmnt;
            this.tmd = tmd;
            this.argsPtr = Q2Statement.make_global_ref(this);
            stmnt.getConnection().registerCallback(this);
            this.pt = new Q2PublishTable(tmd, false);
            this.initialized.compareAndSet(false, true);
        }
    }

    protected final Q2PublishTable getPublishTable() {
        this.checkSetup();
        return this.pt;
    }

    public final Q2Statement getStatement() {
        this.checkSetup();
        return this.stmnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void callback(long tablePtr) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pt.isClosed()) {
                throw new IllegalStateException("PublishTable closed while still being published asynchronously");
            }
            this.pt.setTablePtr(tablePtr);
            this.pt.setWriteable(true);
            this.run();
            this.pt.setWriteable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void takeDown() {
        this.takeDownWithoutDeregisterCallback();
        Object object = this.lock;
        synchronized (object) {
            this.stmnt.getConnection().deregisterCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void takeDownWithoutDeregisterCallback() {
        Object object = this.lock;
        synchronized (object) {
            Q2Statement.delete_global_ref(this.argsPtr);
            this.pt.close();
            this.pt.setTableMetaData(null);
            this.pt = null;
            this.tmd.unsetTable();
            this.tmd = null;
            this.initialized.compareAndSet(true, false);
        }
    }

    final long getArgsPtr() {
        return this.argsPtr;
    }

    final Q2TableMetaData getTableMetaData() {
        return this.tmd;
    }

    final void checkSetup() {
        if (!this.initialized.get()) {
            throw new IllegalStateException("To use this method, callback must be associated with a publish TableMetaData");
        }
    }
}

