(defproject com.akacase/monger "3.2.1-SNAPSHOT"
  :description "Monger is a Clojure MongoDB client for a more civilized age: friendly, flexible and with batteries included"
  :url "http://clojuremongodb.info"
  :min-lein-version "2.5.1"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure        "1.9.0"]
                 [org.mongodb/mongodb-driver "3.9.0"]]
  :test-selectors {:default        (fn [m]
                                     (and (not (:performance m))
                                          (not (:edge-features m))
                                          (not (:time-consuming m))))
                   :focus          :focus
                   :authentication :authentication
                   :updating       :updating
                   :indexing       :indexing
                   :external       :external
                   :cache          :cache
                   :gridfs         :gridfs
                   :command        :command
                   :integration    :integration
                   :performance    :performance
                   ;; as in, edge mongodb server
                   :edge-features  :edge-features
                   :time-consuming :time-consuming
                   :all            (constantly true)}
  :source-paths      ["src/clojure"]
  :java-source-paths ["src/java"]
  :mailing-list {:name    "clojure-mongodb"
                 :archive "https://groups.google.com/group/clojure-mongodb"
                 :post    "clojure-mongodb@googlegroups.com"}
  :profiles {:master {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :dev    {:resource-paths ["test/resources"]
                      :dependencies   [[clj-time               "0.15.0" :exclusions [org.clojure/clojure]]
                                       [cheshire               "5.8.1" :exclusions [org.clojure/clojure]]
                                       [org.clojure/tools.cli  "0.4.1" :exclusions [org.clojure/clojure]]
                                       [org.clojure/core.cache "0.7.1" :exclusions [org.clojure/clojure]]
                                       [ring/ring-core         "1.7.1" :exclusions [org.clojure/clojure]]
                                       [ch.qos.logback/logback-classic "1.2.3" :exclusions [org.slf4j/slf4j-api]]
                                       [ragtime/core   "0.7.2" :exclusions [org.clojure/clojure]]]
                      :plugins        [[lein-codox "0.10.5"]
                                       [lein-exec "0.3.7"]]
                      :codox          {:source-paths ["src/clojure"]
                                       :namespaces   [#"^monger\.(?!internal)"]}}})
