# Monger, a modern Clojure MongoDB Driver
[![CircleCI](https://circleci.com/gh/akacase/monger.svg?style=svg)](https://circleci.com/gh/akacase/monger)

It has batteries included, offers powerful expressive query DSL,
strives to support every MongoDB 3.6+ feature and has sane
defaults. Monger for modern Clojure and sits on top of the official
MongoDB Java driver.


## Immediate TODOs
 - [ ] mark deprecated methods in 3.9
 - [x] $pushAll deprecated for `{$push {:tag {$each ["value1" "value2"]}}}`
 - [ ] transactions (in-progress)
 - [x] SCRAM-256 authentication
 - [ ] change streams -> see `MongoDatabase.watch` and `MongoClient.watch`
 - [x] retryWrites options on 3.6+ -- deprecation of other options.
 - [x] make all tests pass

Open a pull request to add to this list, we will be checking these off
once complete. 

## Project Goals

 * Support most modern MongoDB features.
 * Be [well documented](http://clojuremongodb.info).
 * Be [well tested](https://github.com/akacase/monger/tree/master/test/monger/test).
 * Be as close to the Mongo shell query language as practical
 * Integrate with libraries like Joda Time,
   [Cheshire](https://github.com/dakrone/cheshire),
   [Ragtime](https://github.com/weavejester/ragtime).
 * Support URI connections.
 * Support only latest version of Clojure.

## Artifacts

Monger artifacts are [released to
Clojars](https://clojars.org/com.novemberain/monger).

`[com.novemberain/monger "3.1.0"]`

## Getting Started

Please refer to our [Getting Started
guide](http://clojuremongodb.info/articles/getting_started.html). Don't
hesitate to join our [mailing
list](https://groups.google.com/forum/#!forum/clojure-mongodb) and ask
questions, too!


## Documentation & Examples

Please see our [documentation guides site](http://clojuremongodb.info/) and [API reference](http://reference.clojuremongodb.info).

Our [test
suite](https://github.com/akacase/monger/tree/master/test/monger/test)
also has many code examples.

## Supported Clojure versions

Monger requires Clojure 1.9+. 

## Development

Monger uses [Leiningen 2](https://github.com/technomancy/leiningen/blob/master/doc/TUTORIAL.md). Make sure you have it installed and then run tests against
supported Clojure versions using
    
    lein exec -p bin/ci/before_script.sh
    lein test

Then create a branch and make your changes on it. Once you are done
with your changes and all tests pass, submit a pull request on Github.

## License

Copyright (C) 2011-2018 [Michael S. Klishin](http://twitter.com/michaelklishin), Alex Petrov, and the ClojureWerkz team.

Double licensed under the [Eclipse Public License](http://www.eclipse.org/legal/epl-v10.html) (the same as Clojure) or
the [Apache Public License 2.0](http://www.apache.org/licenses/LICENSE-2.0.html).
