(ns people-shared.components.pg
  (:require [people-shared.utils :as utils]
            [environ.core :refer [env]]
            [jdbc.pool.c3p0 :as c3p0]
            [com.stuartsierra.component :as component]))

(defn c3p0-datasource [uri pool-size]
  (c3p0/make-datasource-spec
   (merge (utils/parse-db-uri uri)
          {:max-pool-size pool-size
           :max-wait 10000})))

(defrecord PG [uri]
  component/Lifecycle
  (start [component]
    (let [pool-size (Integer. (get env :database-pool-size 20))]
      (println "Starting database with pool size" pool-size)
      (assoc component :conn (c3p0-datasource uri pool-size))))
  (stop [component]
    (.close (:conn component))
    (assoc component :conn nil)))
