(ns people-shared.components.cassandra
  (:require [com.stuartsierra.component :as component]
            [qbits.alia :as alia]))

(defrecord Cassandra [hosts keyspace]
  component/Lifecycle
  (start [component]
    (assoc component :session (let [cluster (alia/cluster {:contact-points hosts})]
                                (alia/connect cluster keyspace))))
  (stop [component]
    (alia/shutdown (:session component))
    (assoc component :session nil)))
