(ns people-shared.systems
  (:require [clojure.string :as string]
            [com.stuartsierra.component :as component]
            [people-shared.components
             [cassandra :as cassandra]
             [pg :as pg]
             [rabbitmq :as rabbitmq]]))

(defn cassandra-hosts []
  {:post [(seq %)]}
  (string/split (System/getenv "CASSANDRA_CLUSTER") #","))

(def components
  {:db (pg/map->PG {:uri (System/getenv "DATABASE_URL")})
   :mq (rabbitmq/map->RabbitMQ {:uri (System/getenv "RABBITMQ_URL")})
   :ca (cassandra/map->Cassandra {:hosts cassandra-hosts
                                  :keyspace (System/getenv "CASSANDRA_KEYSPACE")})})

(defn system
  ([component-keys]
   (apply component/system-map
          (flatten (vec (select-keys components component-keys)))))
  ([]
   (system (keys components))))
