(ns people-shared.systems
  (:require [com.stuartsierra.component :as component]
            [environ.core :refer [env]]
            [people-shared.components
             [cassandra :as cassandra]
             [pg :as pg]
             [rabbitmq :as rabbitmq]]))

(def components
  {:db (pg/map->PG {:uri (System/getenv "DATABASE_URL")})
   :mq (rabbitmq/map->RabbitMQ {:uri (System/getenv "RABBITMQ_URL")})
   :ca (cassandra/map->Cassandra {:hosts [(System/getenv "CASSANDRA_URL")]
                                  :keyspace (System/getenv "CASSANDRA_KEYSPACE")})})

(defn system
  ([component-keys]
   (apply component/system-map
          (flatten (vec (select-keys components component-keys)))))
  ([]
   (system (keys components))))
