(ns people-shared.components.rabbitmq
  (:require [clojure.string :as string]
            [com.stuartsierra.component :as component]
            [langohr.core :as rmq]
            [langohr.channel :as lch]
            [langohr.queue :as lq]
            [langohr.consumers :as lc]))

(defn uri->connection-map [s]
  (let [{:keys [host path userInfo]} (bean (java.net.URI. s))
        [username password] (when (seq userInfo)
                              (string/split userInfo #":"))]
    (cond-> {:host host
             :vhost (or (some-> (not-empty path) (string/replace #"^/" ""))
                        "/")}
      username (assoc :username username)
      password (assoc :password password))))

(defrecord RabbitMQ [uri conn ch]
  component/Lifecycle
  (start [component]
    (println ";; Starting RabbitMQ")
    (if ch
      component
      (let [conn (rmq/connect {:uri uri})]
        (assoc component
               :conn conn
               :ch (lch/open conn)))))
  (stop [component]
    (println ";; Stopping RabbitMQ")
    (when (and ch conn)
      (rmq/close ch)
      (rmq/close conn))
    (assoc component
           :conn nil
           :ch nil)))
