(ns people-shared.components.pg
  (:require [people-shared.utils :as utils]
            [jdbc.pool.c3p0 :as c3p0]
            [com.stuartsierra.component :as component]))

(defn c3p0-datasource [uri]
  (c3p0/make-datasource-spec
   (merge (utils/parse-db-uri uri)
          {:initial-pool-size 40
           :max-pool-size 80
           :max-wait 10000})))

(defrecord PG [uri]
  component/Lifecycle
  (start [component]
    (assoc component :conn (c3p0-datasource uri)))
  (stop [component]
    (.close (:conn component))
    (assoc component :conn nil)))
