(ns people-shared.db
  (:require [clojure.string :as string]
            [clojure.java.jdbc :as jdbc]
            [cheshire.core :as json])
  (:import [org.postgresql.util PGobject]
           [org.postgresql.jdbc4 Jdbc4Array]
           [java.io PrintWriter]))

(def query jdbc/query)
(def execute! jdbc/execute!)
(def insert! jdbc/insert!)

(extend-protocol jdbc/IResultSetReadColumn
  Jdbc4Array
  (result-set-read-column  [pgobj _ _]
    (vec (.getArray pgobj)))
  PGobject
  (result-set-read-column [pgobj _ _]
    (let [type-name (.getType pgobj)
          value (.getValue pgobj)]
      (case type-name
        ("json" "jsonb") (json/parse-string value true)
        value))))

(extend-protocol jdbc/ISQLParameter
  clojure.lang.IPersistentVector
  (set-parameter [v ^java.sql.PreparedStatement stmt ^long i]
    (let [conn (.getConnection stmt)
          meta (.getParameterMetaData stmt)
          type-name (.getParameterTypeName meta i)]
      (.setObject stmt i (case type-name
                           ("json" "jsonb") (doto (PGobject.)
                                              (.setType type-name)
                                              (.setValue (json/generate-string v)))
                           (if-let [elem-type (nth (re-find #"(^_)?(\w+)(\[\]$)?" type-name) 2)]
                             (.createArrayOf conn elem-type
                                             (to-array (if (get #{"jsonb" "json"} elem-type)
                                                         (map json/generate-string v)
                                                         v)))
                             v))))))
