(ns people-shared.systems
  (:require [com.stuartsierra.component :as component]
            [people-shared.components
             [pg :as pg]
             [rabbitmq :as rabbitmq]]))

(def components
  {:db (pg/map->PG {:uri (System/getenv "DATABASE_URL")})
   :mq (rabbitmq/map->RabbitMQ {:uri (System/getenv "RABBITMQ_URL")})})

(defn system
  ([component-keys]
   (apply component/system-map
          (flatten (vec (select-keys components component-keys)))))
  ([]
   (system (keys components))))
