/*
 * Decompiled with CFR 0.152.
 */
package net.citrusleaf;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citrusleaf.ScanForwarder;

public class CitrusleafClient
extends AerospikeClient
implements Log.Callback {
    static final int DEFAULT_TIMEOUT = 5000;
    private static final String DEFAULT_NAMESPACE = "ns";
    private static SimpleDateFormat gSdf = null;
    private static ClLogLevel gLogLevel = ClLogLevel.INFO;
    private static LogCallback gLogCallback = null;
    private String mDefaultNamespace = "ns";
    private final WritePolicy defaultWritePolicy;
    private final Policy defaultPolicy;
    private static final ClLogLevel[] ClLogLevelLookup = ClLogLevel.values();

    public CitrusleafClient() {
        this.ClLogInit();
        this.defaultWritePolicy = new WritePolicy();
        this.defaultWritePolicy.timeout = 5000;
        this.defaultPolicy = new Policy();
        this.defaultPolicy.timeout = 5000;
    }

    public CitrusleafClient(String hostname, int port) {
        this.ClLogInit();
        this.defaultWritePolicy = new WritePolicy();
        this.defaultWritePolicy.timeout = 5000;
        this.defaultPolicy = new Policy();
        this.defaultPolicy.timeout = 5000;
        try {
            super.addServer(hostname, port);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLogging(ClLogLevel level, LogCallback logCb) {
        Log.Level ll;
        gLogLevel = level;
        gLogCallback = logCb;
        switch (level) {
            case ERROR: {
                ll = Log.Level.ERROR;
                break;
            }
            case WARN: {
                ll = Log.Level.WARN;
                break;
            }
            default: {
                ll = Log.Level.INFO;
                break;
            }
            case DEBUG: 
            case VERBOSE: {
                ll = Log.Level.DEBUG;
            }
        }
        Log.setLevel(ll);
    }

    @Override
    public void log(Log.Level level, String message) {
        ClLogLevel cll = ClLogLevelLookup[level.ordinal()];
        CitrusleafClient.ClLog(cll, message);
    }

    public ClResultCode addHost(String hostname, int port) {
        try {
            super.addServer(hostname, port);
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    @Deprecated
    public boolean connect() {
        return super.isConnected();
    }

    public List<String> getNodeNameList() {
        return super.getNodeNames();
    }

    public void setDefaultNamespace(String namespace) {
        this.mDefaultNamespace = namespace;
    }

    public static byte[] computeDigest(String set, Object key) {
        try {
            return Key.computeDigest(set, Value.get(key));
        }
        catch (AerospikeException ae) {
            return null;
        }
    }

    public ClResultCode set(Object key, Object value) {
        try {
            super.put(this.defaultWritePolicy, new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode set(Object key, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode set(String namespace, String set, Object key, String binName, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), new Bin(binName, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode set(String namespace, String set, Object key, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode set(String namespace, String set, Object key, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode setDigest(String namespace, byte[] digest, String binName, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), new Bin(binName, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode setDigest(String namespace, byte[] digest, ClBin bin, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), new Bin(bin.name, bin.value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode setDigest(String namespace, byte[] digest, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode setDigest(String namespace, byte[] digest, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.put(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode append(Object key, Object value) {
        try {
            super.append(this.defaultWritePolicy, new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode append(Object key, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.append(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode append(String namespace, String set, Object key, String binName, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.append(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), new Bin(binName, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode append(String namespace, String set, Object key, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.append(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode append(String namespace, String set, Object key, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.append(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode prepend(Object key, Object value) {
        try {
            super.prepend(this.defaultWritePolicy, new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode prepend(Object key, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.prepend(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode prepend(String namespace, String set, Object key, String binName, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.prepend(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), new Bin(binName, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode prepend(String namespace, String set, Object key, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.prepend(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode prepend(String namespace, String set, Object key, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.prepend(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode add(Object key, Object value) {
        try {
            super.add(this.defaultWritePolicy, new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode add(Object key, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(this.mDefaultNamespace, "", Value.get(key)), new Bin(null, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode add(String namespace, String set, Object key, String binName, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), new Bin(binName, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode add(String namespace, String set, Object key, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode add(String namespace, String set, Object key, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResult addAndGet(String namespace, String set, Object key, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        Operation[] operations = new Operation[bins.size() + 1];
        int count = 0;
        for (ClBin bin : bins) {
            operations[count++] = Operation.add(new Bin(bin.name, bin.value));
        }
        operations[count] = Operation.get();
        try {
            Record record = super.operate(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), operations);
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult addAndGet(String namespace, String set, Object key, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        Operation[] operations = new Operation[bins.size() + 1];
        int count = 0;
        for (Map.Entry<String, Object> entry : bins.entrySet()) {
            operations[count++] = Operation.add(new Bin(entry.getKey(), entry.getValue()));
        }
        operations[count] = Operation.get();
        try {
            Record record = super.operate(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), operations);
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResultCode addDigest(String namespace, byte[] digest, String binName, Object value, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), new Bin(binName, value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode addDigest(String namespace, byte[] digest, ClBin bin, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), new Bin(bin.name, bin.value));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode addDigest(String namespace, byte[] digest, Collection<ClBin> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode addDigest(String namespace, byte[] digest, Map<String, Object> bins, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.add(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest), CitrusleafClient.getBins(bins));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode delete(Object key, ClOptions opts, ClWriteOptions wOpts) {
        try {
            if (super.delete(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(this.mDefaultNamespace, "", Value.get(key)))) {
                return ClResultCode.OK;
            }
            return ClResultCode.KEY_NOT_FOUND_ERROR;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode delete(String namespace, String set, Object key, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.delete(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode deleteDigest(String namespace, byte[] digest, ClOptions opts, ClWriteOptions wOpts) {
        try {
            super.delete(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, digest));
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public Object get(Object key) {
        try {
            Record record = super.get(this.defaultPolicy, new Key(this.mDefaultNamespace, "", Value.get(key)), "");
            ClResult r = CitrusleafClient.getResult(record);
            return r.results != null ? r.results.get("") : null;
        }
        catch (AerospikeException ae) {
            return null;
        }
    }

    public ClResult get(String namespace, String set, Object key, String binName, ClOptions opts) {
        try {
            String name = binName == null ? "" : binName;
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, set, Value.get(key)), name);
            ClResult r = CitrusleafClient.getResult(record);
            if (r.results != null) {
                r.result = r.results.get(name);
            }
            return r;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult get(String namespace, String set, Object key, String[] binNames, ClOptions opts) {
        try {
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, set, Value.get(key)), binNames);
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult get(String namespace, String set, Object key, Collection<String> binNames, ClOptions opts) {
        try {
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, set, Value.get(key)), CitrusleafClient.getBinNames(binNames));
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult getAll(String namespace, String set, Object key, ClOptions opts) {
        try {
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, set, Value.get(key)));
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult getWithTouch(String namespace, String set, Object key, Collection<String> binNames, int expiration, ClOptions opts) {
        ClWriteOptions wOpts = new ClWriteOptions();
        wOpts.expiration = expiration;
        Operation[] operations = new Operation[binNames.size() + 1];
        int count = 0;
        for (String binName : binNames) {
            operations[count++] = Operation.get(binName);
        }
        operations[count] = Operation.touch();
        try {
            Record record = super.operate(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), operations);
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult[] batchGet(String namespace, String set, Collection<Object> keys2, String binName, ClOptions opts) {
        try {
            Key[] keyArray = CitrusleafClient.getKeys(namespace, set, keys2);
            Record[] records = super.get(CitrusleafClient.getPolicy(opts), keyArray, binName);
            return CitrusleafClient.getRecordResults(records);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResults(ae, keys2.size());
        }
    }

    public ClResult[] batchGet(String namespace, String set, Collection<Object> keys2, Collection<String> binNames, ClOptions opts) {
        try {
            Key[] keyArray = CitrusleafClient.getKeys(namespace, set, keys2);
            Record[] records = super.get(CitrusleafClient.getPolicy(opts), keyArray, CitrusleafClient.getBinNames(binNames));
            return CitrusleafClient.getRecordResults(records);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResults(ae, keys2.size());
        }
    }

    public ClResult[] batchGetAll(String namespace, String set, Collection<Object> keys2, ClOptions opts) {
        try {
            Key[] keyArray = CitrusleafClient.getKeys(namespace, set, keys2);
            Record[] records = super.get(CitrusleafClient.getPolicy(opts), keyArray);
            return CitrusleafClient.getRecordResults(records);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResults(ae, keys2.size());
        }
    }

    public ClResult getDigest(String namespace, byte[] digest, String binName, ClOptions opts) {
        try {
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, digest), binName);
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult getDigest(String namespace, byte[] digest, Collection<String> binNames, ClOptions opts) {
        try {
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, digest), CitrusleafClient.getBinNames(binNames));
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResult getAllDigest(String namespace, byte[] digest, ClOptions opts) {
        try {
            Record record = super.get(CitrusleafClient.getPolicy(opts), new Key(namespace, digest));
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResultCode exists(Object key) {
        try {
            boolean exists = super.exists(this.defaultPolicy, new Key(this.mDefaultNamespace, "", Value.get(key)));
            return exists ? ClResultCode.OK : ClResultCode.KEY_NOT_FOUND_ERROR;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode exists(String namespace, String set, Object key, ClOptions opts) {
        try {
            boolean exists = super.exists(CitrusleafClient.getPolicy(opts), new Key(namespace, set, Value.get(key)));
            return exists ? ClResultCode.OK : ClResultCode.KEY_NOT_FOUND_ERROR;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResult[] batchExists(String namespace, String set, Collection<Object> keys2, ClOptions opts) {
        try {
            Key[] keyArray = CitrusleafClient.getKeys(namespace, set, keys2);
            boolean[] existsArray = super.exists(CitrusleafClient.getPolicy(opts), keyArray);
            return CitrusleafClient.getKeyResults(existsArray);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResults(ae, keys2.size());
        }
    }

    @Deprecated
    public ClResult scan(String namespace, ClOptions opts, ScanCallback scanCb, Object userData) {
        return this.scan(namespace, null, opts, scanCb, userData, false);
    }

    @Deprecated
    public ClResult scan(String namespace, String set, ClOptions opts, ScanCallback scanCb, Object userData) {
        return this.scan(namespace, set, opts, scanCb, userData, false);
    }

    @Deprecated
    public ClResult scan(String namespace, ClOptions opts, ScanCallback scanCb, Object userData, boolean noBinData) {
        return this.scan(namespace, null, opts, scanCb, userData, noBinData);
    }

    @Deprecated
    public ClResult scan(String namespace, String set, ClOptions opts, ScanCallback scanCb, Object userData, boolean noBinData) {
        try {
            ScanForwarder sf = new ScanForwarder(scanCb, userData);
            super.scanAll(CitrusleafClient.getScanPolicy(opts, null, noBinData), namespace, set, sf);
            return new ClResult(ClResultCode.OK);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    public ClResultCode scanNode(String nodeName, String namespace, String set, boolean noBinData, int scanPercent, ClOptions opts, ClScanningOptions scanOpts, ScanCallback scanCb, Object userData) {
        try {
            ScanForwarder sf = new ScanForwarder(scanCb, userData);
            super.scanNode(CitrusleafClient.getScanPolicy(opts, scanOpts, noBinData), nodeName, namespace, set, (com.aerospike.client.ScanCallback)sf);
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public ClResultCode scan(String namespace, String set, ScanCallback scanCb, Object userData) {
        try {
            ScanForwarder sf = new ScanForwarder(scanCb, userData);
            super.scanAll(CitrusleafClient.getScanPolicy(null, null, false), namespace, set, sf);
            return ClResultCode.OK;
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCode(ae);
        }
    }

    public Map<String, ClResultCode> scanAllNodes(String namespace, String set, ScanCallback scanCb, Object userData) {
        return this.scanAllNodes(namespace, set, false, 100, null, null, scanCb, userData);
    }

    public Map<String, ClResultCode> scanAllNodes(String namespace, String set, ClOptions opts, ClScanningOptions scanOpts, ScanCallback scanCb, Object userData) {
        return this.scanAllNodes(namespace, set, false, 100, opts, scanOpts, scanCb, userData);
    }

    public Map<String, ClResultCode> scanAllNodes(String namespace, String set, boolean noBinData, int scanPercent, ClOptions opts, ClScanningOptions scanOpts, ScanCallback scanCb, Object userData) {
        List<String> nodeNames = super.getNodeNames();
        try {
            ScanForwarder sf = new ScanForwarder(scanCb, userData);
            super.scanAll(CitrusleafClient.getScanPolicy(opts, scanOpts, noBinData), namespace, set, sf);
            return CitrusleafClient.getResultCodes(ClResultCode.OK, nodeNames);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResultCodes(ae, nodeNames);
        }
    }

    public ClResult operate(String namespace, String set, Object key, Collection<String> readBinNames, Collection<ClBin> writeBins, ClOptions opts, ClWriteOptions wOpts) {
        Operation[] operations = new Operation[readBinNames.size() + writeBins.size()];
        int count = 0;
        for (ClBin bin : writeBins) {
            operations[count++] = Operation.put(new Bin(bin.name, bin.value));
        }
        for (String binName : readBinNames) {
            operations[count++] = Operation.get(binName);
        }
        try {
            Record record = super.operate(CitrusleafClient.getWritePolicy(opts, wOpts), new Key(namespace, set, Value.get(key)), operations);
            return CitrusleafClient.getResult(record);
        }
        catch (AerospikeException ae) {
            return CitrusleafClient.getResult(ae);
        }
    }

    private void ClLogInit() {
        if (gSdf == null) {
            gSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        }
        Log.setLevel(Log.Level.INFO);
        Log.setCallback(this);
    }

    public static void ClLog(ClLogLevel logLevel, String msg) {
        if (logLevel.ordinal() > gLogLevel.ordinal()) {
            return;
        }
        if (gLogCallback != null) {
            gLogCallback.logCallback(logLevel, msg);
            return;
        }
        String date = gSdf != null ? gSdf.format(new Date()) : "";
        System.err.println(date + " CITRUSLEAF [" + Thread.currentThread().getId() + "] " + msg);
    }

    private static ScanPolicy getScanPolicy(ClOptions opts, ClScanningOptions scanOpts, boolean noBinData) {
        ScanPolicy policy = new ScanPolicy();
        if (opts != null) {
            policy.timeout = opts.mTimeout;
            policy.maxRetries = 0;
        }
        if (scanOpts != null) {
            policy.concurrentNodes = scanOpts.mConcurrentNodes;
            policy.failOnClusterChange = scanOpts.mFailOnClusterChange;
        }
        policy.includeBinData = !noBinData;
        policy.scanPercent = 100;
        return policy;
    }

    private static WritePolicy getWritePolicy(ClOptions opts, ClWriteOptions wOpts) {
        WritePolicy policy = new WritePolicy();
        CitrusleafClient.setPolicy(opts, policy);
        if (wOpts != null) {
            policy.expiration = wOpts.expiration;
            if (wOpts.unique) {
                policy.recordExistsAction = RecordExistsAction.FAIL;
            } else if (wOpts.mUseGeneration) {
                policy.generation = wOpts.mGeneration;
                policy.recordExistsAction = RecordExistsAction.EXPECT_GEN_EQUAL;
            } else if (wOpts.mUseGenerationGt) {
                policy.generation = wOpts.mGeneration;
                policy.recordExistsAction = RecordExistsAction.EXPECT_GEN_GT;
            } else if (wOpts.mUseGenerationDup) {
                policy.generation = wOpts.mGeneration;
                policy.recordExistsAction = RecordExistsAction.DUPLICATE;
            }
        }
        return policy;
    }

    private static Policy getPolicy(ClOptions opts) {
        Policy policy = new Policy();
        CitrusleafClient.setPolicy(opts, policy);
        return policy;
    }

    private static void setPolicy(ClOptions opts, Policy policy) {
        if (opts != null) {
            policy.timeout = opts.mTimeout;
            if (opts.mRetryPolicy == RetryPolicy.ONE_SHOT) {
                policy.maxRetries = 0;
            } else {
                policy.sleepBetweenRetries = policy.timeout / (policy.maxRetries + 1);
                if (policy.sleepBetweenRetries > 2000) {
                    policy.sleepBetweenRetries = 2000;
                }
            }
        } else {
            policy.timeout = 5000;
            policy.maxRetries = 2;
            policy.sleepBetweenRetries = policy.timeout / (policy.maxRetries + 1);
        }
    }

    private static Key[] getKeys(String namespace, String set, Collection<Object> keys2) throws AerospikeException {
        Key[] keyArray = new Key[keys2.size()];
        int count = 0;
        for (Object key : keys2) {
            keyArray[count++] = new Key(namespace, set, Value.get(key));
        }
        return keyArray;
    }

    private static Bin[] getBins(Collection<ClBin> bins) throws AerospikeException {
        if (bins == null) {
            throw new AerospikeException(4, "Null bins");
        }
        Bin[] binArray = new Bin[bins.size()];
        int count = 0;
        for (ClBin bin : bins) {
            binArray[count++] = new Bin(bin.name, bin.value);
        }
        return binArray;
    }

    private static Bin[] getBins(Map<String, Object> bins) throws AerospikeException {
        if (bins == null) {
            throw new AerospikeException(4, "Null bins");
        }
        Bin[] binArray = new Bin[bins.size()];
        int count = 0;
        for (Map.Entry<String, Object> entry : bins.entrySet()) {
            binArray[count++] = new Bin(entry.getKey(), entry.getValue());
        }
        return binArray;
    }

    private static String[] getBinNames(Collection<String> binNames) throws AerospikeException {
        if (binNames == null) {
            throw new AerospikeException(4, "Null bin names");
        }
        String[] binArray = new String[binNames.size()];
        int count = 0;
        for (String binName : binNames) {
            binArray[count++] = binName;
        }
        return binArray;
    }

    private static ClResult[] getRecordResults(Record[] records) {
        ClResult[] results = new ClResult[records.length];
        for (int i = 0; i < records.length; ++i) {
            results[i] = CitrusleafClient.getResult(records[i]);
        }
        return results;
    }

    private static ClResult[] getKeyResults(boolean[] existsArray) {
        ClResult[] results = new ClResult[existsArray.length];
        for (int i = 0; i < existsArray.length; ++i) {
            ClResultCode rc = existsArray[i] ? ClResultCode.OK : ClResultCode.KEY_NOT_FOUND_ERROR;
            results[i] = new ClResult(rc);
        }
        return results;
    }

    private static ClResult getResult(Record record) {
        ClResult clr;
        if (record != null) {
            clr = new ClResult(ClResultCode.OK);
            clr.results = record.bins;
            clr.generation = record.generation;
            clr.results_dup = record.duplicates;
        } else {
            clr = new ClResult(ClResultCode.KEY_NOT_FOUND_ERROR);
        }
        return clr;
    }

    private static ClResult[] getResults(AerospikeException ae, int size) {
        ClResult[] array = new ClResult[size];
        ClResult result = new ClResult(CitrusleafClient.getResultCode(ae));
        for (int i = 0; i < size; ++i) {
            array[i] = result;
        }
        return array;
    }

    private static ClResult getResult(AerospikeException ae) {
        return new ClResult(CitrusleafClient.getResultCode(ae));
    }

    private static Map<String, ClResultCode> getResultCodes(AerospikeException ae, List<String> nodeNames) {
        ClResultCode rc = CitrusleafClient.getResultCode(ae);
        return CitrusleafClient.getResultCodes(rc, nodeNames);
    }

    private static Map<String, ClResultCode> getResultCodes(ClResultCode rc, List<String> nodeNames) {
        HashMap<String, ClResultCode> map = new HashMap<String, ClResultCode>(nodeNames.size());
        for (String nodeName : nodeNames) {
            map.put(nodeName, rc);
        }
        return map;
    }

    private static ClResultCode getResultCode(AerospikeException ae) {
        switch (ae.getResultCode()) {
            case -3: 
            case -2: {
                return ClResultCode.CLIENT_ERROR;
            }
            case -1: {
                return ClResultCode.SERIALIZE_ERROR;
            }
            case 0: {
                return ClResultCode.OK;
            }
            default: {
                return ClResultCode.SERVER_ERROR;
            }
            case 2: {
                return ClResultCode.KEY_NOT_FOUND_ERROR;
            }
            case 3: {
                return ClResultCode.GENERATION_ERROR;
            }
            case 4: {
                return ClResultCode.PARAMETER_ERROR;
            }
            case 5: {
                return ClResultCode.KEY_EXISTS_ERROR;
            }
            case 6: {
                return ClResultCode.BIN_EXISTS_ERROR;
            }
            case 7: {
                return ClResultCode.CLUSTER_KEY_MISMATCH;
            }
            case 8: {
                return ClResultCode.SERVER_MEM_ERROR;
            }
            case 9: {
                return ClResultCode.TIMEOUT;
            }
            case 10: {
                return ClResultCode.NO_XDS;
            }
            case 11: {
                return ClResultCode.SERVER_NOT_AVAILABLE;
            }
            case 12: {
                return ClResultCode.BIN_TYPE_ERROR;
            }
            case 13: {
                return ClResultCode.RECORD_TOO_BIG;
            }
            case 14: 
        }
        return ClResultCode.KEY_BUSY;
    }

    public static class ClBin {
        public String name;
        public Object value;

        public ClBin() {
            this.name = null;
            this.value = null;
        }

        public ClBin(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class ClResult {
        public ClResultCode resultCode = ClResultCode.NOT_SET;
        public int generation = -1;
        public boolean corruptedData = false;
        public Object result = null;
        public Map<String, Object> results = null;
        public List<Map<String, Object>> results_dup = null;
        ClResult[] resultArray = null;

        public ClResult() {
        }

        public ClResult(ClResultCode resultCode) {
            this.resultCode = resultCode;
        }

        public static String resultCodeToString(ClResultCode resultCode) {
            switch (resultCode) {
                case OK: {
                    return "OK";
                }
                case NOT_SET: {
                    return "result code has not been set";
                }
                case SERVER_ERROR: {
                    return "server error";
                }
                case TIMEOUT: {
                    return "timeout";
                }
                case CLIENT_ERROR: {
                    return "client error";
                }
                case KEY_NOT_FOUND_ERROR: {
                    return "key not found error";
                }
                case GENERATION_ERROR: {
                    return "generation error";
                }
                case PARAMETER_ERROR: {
                    return "parameter error";
                }
                case KEY_EXISTS_ERROR: {
                    return "key exists error";
                }
                case BIN_EXISTS_ERROR: {
                    return "bin exists error";
                }
                case SERIALIZE_ERROR: {
                    return "serialize error";
                }
                case CLUSTER_KEY_MISMATCH: {
                    return "cluster key mismatch";
                }
                case SERVER_MEM_ERROR: {
                    return "server memory error";
                }
                case NO_XDS: {
                    return "XDS product not available";
                }
                case SERVER_NOT_AVAILABLE: {
                    return "server not available";
                }
                case BIN_TYPE_ERROR: {
                    return "bin type error";
                }
                case RECORD_TOO_BIG: {
                    return "record too big";
                }
                case KEY_BUSY: {
                    return "key busy";
                }
            }
            return "unknown error " + (Object)((Object)resultCode);
        }
    }

    public static class ClScanningOptions {
        private boolean mConcurrentNodes = true;
        private int mThreadsPerNode = 1;
        private ClScanningPriority mPriority = ClScanningPriority.AUTO;
        private boolean mFailOnClusterChange = false;

        public boolean isConcurrentNodes() {
            return this.mConcurrentNodes;
        }

        public void setConcurrentNodes(boolean concurrentNodes) {
            this.mConcurrentNodes = concurrentNodes;
        }

        public int getThreadsPerNode() {
            return this.mThreadsPerNode;
        }

        public void setThreadsPerNode(int threadsPerNode) {
            this.mThreadsPerNode = threadsPerNode;
        }

        public ClScanningPriority getPriority() {
            return this.mPriority;
        }

        public void setPriority(ClScanningPriority priority) {
            this.mPriority = priority;
        }

        public boolean isFailOnClusterChange() {
            return this.mFailOnClusterChange;
        }

        public void setFailOnClusterChange(boolean failOnClusterChange) {
            this.mFailOnClusterChange = failOnClusterChange;
        }
    }

    public static class ClWriteOptions {
        public int expiration = 0;
        public boolean unique = false;
        boolean mUseGeneration = false;
        boolean mUseGenerationGt = false;
        boolean mUseGenerationDup = false;
        int mGeneration = 0;

        public void set_generation(int generation) {
            this.mUseGeneration = true;
            this.mGeneration = generation;
        }

        public void set_generation_gt(int generation) {
            this.mUseGenerationGt = true;
            this.mGeneration = generation;
        }

        public void set_generation_dup(int generation) {
            this.mUseGenerationDup = true;
            this.mGeneration = generation;
        }
    }

    public static class ClOptions {
        int mTimeout;
        RetryPolicy mRetryPolicy;

        public ClOptions() {
            this.mTimeout = 5000;
            this.mRetryPolicy = RetryPolicy.RETRY;
        }

        public ClOptions(int timeoutMillisec) {
            this.mTimeout = timeoutMillisec;
            this.mRetryPolicy = RetryPolicy.RETRY;
        }

        public void setOneShot() {
            this.mRetryPolicy = RetryPolicy.ONE_SHOT;
        }

        public void setTimeout(int timeoutMillisec) {
            this.mTimeout = timeoutMillisec;
        }

        static boolean wantsRetry(ClOptions opts) {
            return opts == null || opts.mRetryPolicy != RetryPolicy.ONE_SHOT;
        }
    }

    public static interface ScanCallback {
        public void scanCallback(String var1, String var2, byte[] var3, Map<String, Object> var4, int var5, int var6, Object var7);
    }

    public static interface LogCallback {
        public void logCallback(ClLogLevel var1, String var2);
    }

    private static enum RetryPolicy {
        ONE_SHOT,
        RETRY;

    }

    public static enum ClLogLevel {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }

    public static enum ClScanningPriority {
        AUTO,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum ClResultCode {
        OK,
        NOT_SET,
        SERVER_ERROR,
        TIMEOUT,
        CLIENT_ERROR,
        KEY_NOT_FOUND_ERROR,
        GENERATION_ERROR,
        PARAMETER_ERROR,
        KEY_EXISTS_ERROR,
        BIN_EXISTS_ERROR,
        SERIALIZE_ERROR,
        CLUSTER_KEY_MISMATCH,
        SERVER_MEM_ERROR,
        NO_XDS,
        SERVER_NOT_AVAILABLE,
        BIN_TYPE_ERROR,
        RECORD_TOO_BIG,
        KEY_BUSY;

    }
}

