/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.MsgPack;

public abstract class QueryCommand
extends MultiCommand {
    protected volatile boolean valid = true;

    public QueryCommand(Node node) {
        super(node);
    }

    public void query(QueryPolicy policy, Statement statement) throws AerospikeException {
        byte[] functionArgBuffer = null;
        int fieldCount = 0;
        int filterSize = 0;
        int binNameSize = 0;
        if (statement.namespace != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(statement.namespace) + 5;
            ++fieldCount;
        }
        if (statement.indexName != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(statement.indexName) + 5;
            ++fieldCount;
        }
        if (statement.setName != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(statement.setName) + 5;
            ++fieldCount;
        }
        if (statement.filters != null) {
            this.sendOffset += 5;
            ++filterSize;
            for (Filter filter : statement.filters) {
                filterSize += filter.estimateSize();
            }
            this.sendOffset += filterSize;
            ++fieldCount;
        } else {
            this.sendOffset += 7;
            ++fieldCount;
        }
        if (statement.binNames != null) {
            this.sendOffset += 5;
            ++binNameSize;
            for (String binName : statement.binNames) {
                binNameSize += Buffer.estimateSizeUtf8(binName) + 1;
            }
            this.sendOffset += binNameSize;
            ++fieldCount;
        }
        if (statement.taskId > 0) {
            this.sendOffset += 13;
            ++fieldCount;
        }
        if (statement.functionName != null) {
            this.sendOffset += 6;
            this.sendOffset += Buffer.estimateSizeUtf8(statement.packageName) + 5;
            this.sendOffset += Buffer.estimateSizeUtf8(statement.functionName) + 5;
            functionArgBuffer = statement.functionArgs.length > 0 ? MsgPack.pack(statement.functionArgs) : new byte[]{};
            this.sendOffset += 5 + functionArgBuffer.length;
            fieldCount += 4;
        }
        this.begin();
        int readAttr = 1;
        this.writeHeader(readAttr, fieldCount, 0);
        if (statement.namespace != null) {
            this.writeField(statement.namespace, 0);
        }
        if (statement.indexName != null) {
            this.writeField(statement.indexName, 21);
        }
        if (statement.setName != null) {
            this.writeField(statement.setName, 1);
        }
        if (statement.filters != null) {
            this.writeFieldHeader(filterSize, 22);
            this.sendBuffer[this.sendOffset++] = (byte)statement.filters.length;
            for (Filter filter : statement.filters) {
                this.sendOffset = filter.write(this.sendBuffer, this.sendOffset);
            }
        } else {
            this.writeFieldHeader(2, 8);
            byte priority = (byte)policy.priority.ordinal();
            priority = (byte)(priority << 4);
            this.sendBuffer[this.sendOffset++] = priority;
            this.sendBuffer[this.sendOffset++] = 100;
        }
        if (statement.binNames != null) {
            this.writeFieldHeader(binNameSize, 40);
            this.sendBuffer[this.sendOffset++] = (byte)statement.binNames.length;
            for (String binName : statement.binNames) {
                int len2 = Buffer.stringToUtf8(binName, this.sendBuffer, this.sendOffset + 1);
                this.sendBuffer[this.sendOffset] = (byte)len2;
                this.sendOffset += len2 + 1;
            }
        }
        if (statement.taskId > 0) {
            this.writeFieldHeader(8, 7);
            Buffer.longToBytes(statement.taskId, this.sendBuffer, this.sendOffset);
            this.sendOffset += 8;
        }
        if (statement.functionName != null) {
            this.writeFieldHeader(1, 33);
            this.sendBuffer[this.sendOffset++] = 1;
            this.writeField(statement.packageName, 30);
            this.writeField(statement.functionName, 31);
            this.writeField(functionArgBuffer, 32);
        }
        this.end();
        this.execute(policy);
    }

    public final void stop() {
        this.valid = false;
    }
}

