/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaBytesLib;
import com.aerospike.client.lua.LuaCache;
import com.aerospike.client.lua.LuaJavaBlob;
import com.aerospike.client.lua.LuaList;
import com.aerospike.client.lua.LuaListLib;
import com.aerospike.client.lua.LuaMap;
import com.aerospike.client.lua.LuaMapLib;
import com.aerospike.client.lua.LuaStreamLib;
import com.aerospike.client.util.MsgPack;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.CoroutineLib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.StringLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseIoLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseOsLib;
import org.luaj.vm2.lib.jse.LuajavaLib;

public final class LuaInstance {
    private final Globals globals = new Globals();
    private final PackageLib packageLib;

    public LuaInstance() throws IOException {
        this.globals.load((LuaValue)new JseBaseLib());
        this.packageLib = new PackageLib();
        this.globals.load((LuaValue)this.packageLib);
        this.globals.load((LuaValue)new TableLib());
        this.globals.load((LuaValue)new StringLib());
        this.globals.load((LuaValue)new CoroutineLib());
        this.globals.load((LuaValue)new JseMathLib());
        this.globals.load((LuaValue)new JseIoLib());
        this.globals.load((LuaValue)new JseOsLib());
        this.globals.load((LuaValue)new LuajavaLib());
        this.globals.load((LuaValue)new DebugLib());
        this.globals.load((LuaValue)new LuaBytesLib(this));
        this.globals.load((LuaValue)new LuaListLib(this));
        this.globals.load((LuaValue)new LuaMapLib(this));
        this.globals.load((LuaValue)new LuaStreamLib(this));
        LuaC.install();
        this.globals.compiler = LuaC.instance;
        this.load("compat52");
        this.load("as");
        this.load("stream_ops");
        this.load("aerospike");
    }

    public void registerPackage(String packageName, LuaTable table) {
        this.globals.set(packageName, (LuaValue)table);
        this.packageLib.loaded.set(packageName, (LuaValue)table);
    }

    public LuaValue getPackage(String packageName) {
        return this.globals.get(packageName);
    }

    public void load(LibFunction function) {
        this.globals.load((LuaValue)function);
    }

    public void load(String packageName) throws IOException {
        if (this.packageLib.loaded.get(packageName).toboolean()) {
            return;
        }
        Prototype prototype = LuaCache.loadPackage(packageName);
        LuaClosure function = new LuaClosure(prototype, (LuaValue)this.globals);
        function.invoke();
        this.packageLib.loaded.set(packageName, (LuaValue)this.globals);
    }

    public void call(String functionName, LuaValue[] args) {
        this.globals.get(functionName).invoke(args);
    }

    public LuaValue getFunction(String functionName) {
        return this.globals.get(functionName);
    }

    public static LuaValue getValue(int type, byte[] buf, int offset, int len2) throws AerospikeException {
        if (len2 <= 0) {
            return LuaValue.NIL;
        }
        switch (type) {
            case 3: {
                byte[] copy = new byte[len2];
                System.arraycopy(buf, offset, copy, 0, len2);
                return LuaString.valueOf((byte[])copy, (int)0, (int)len2);
            }
            case 1: {
                if (len2 <= 4) {
                    return LuaInteger.valueOf((int)Buffer.bytesToInt(buf, offset));
                }
                if (len2 <= 8) {
                    return LuaInteger.valueOf((long)Buffer.bytesToLong(buf, offset));
                }
                throw new AerospikeException("Lua BigInteger not implemented.");
            }
            case 4: {
                byte[] blob = new byte[len2];
                System.arraycopy(buf, offset, blob, 0, len2);
                return LuaString.valueOf((byte[])blob, (int)0, (int)len2);
            }
            case 7: {
                Object object = Buffer.bytesToObject(buf, offset, len2);
                return new LuaJavaBlob(object);
            }
            case 20: {
                List<?> list = MsgPack.parseList(buf, offset, len2);
                return new LuaList(list);
            }
            case 19: {
                Map<?, ?> map = MsgPack.parseMap(buf, offset, len2);
                return new LuaMap(map);
            }
        }
        return LuaValue.NIL;
    }
}

