/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaBytes;
import com.aerospike.client.lua.LuaInstance;
import java.util.Arrays;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public final class LuaBytesLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaBytesLib(LuaInstance instance) {
        this.instance = instance;
        instance.load((LibFunction)new MetaLib(instance));
    }

    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 8);
        table.setmetatable((LuaValue)meta);
        table.set("size", (LuaValue)new len());
        table.set("tostring", (LuaValue)new tostring());
        new putint(table, 0, "put_int16");
        new putint(table, 1, "put_int32");
        new putint(table, 2, "put_int64");
        table.set("put_string", (LuaValue)new put_string());
        table.set("put_bytes", (LuaValue)new put_bytes());
        new putint(table, 0, "set_int16");
        new putint(table, 1, "set_int32");
        new putint(table, 2, "set_int64");
        table.set("set_string", (LuaValue)new put_string());
        table.set("set_bytes", (LuaValue)new put_bytes());
        new getint(table, 0, "get_int16");
        new getint(table, 1, "get_int32");
        new getint(table, 2, "get_int64");
        table.set("get_string", (LuaValue)new get_string());
        table.set("get_bytes", (LuaValue)new get_bytes());
        table.set("set_len", (LuaValue)new set_len());
        this.instance.registerPackage("bytes", table);
        return table;
    }

    public static final class set_len
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaBytes bytes = (LuaBytes)arg1;
            int length = arg2.toint() - 1;
            bytes.setLength(length);
            return bytes;
        }
    }

    public static final class get_bytes
    extends ThreeArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            byte[] src = ((LuaBytes)arg1).bytes;
            int srcPos = arg2.toint() - 1;
            int length = arg3.toint();
            if (srcPos > src.length) {
                return NIL;
            }
            int remaining = src.length - srcPos;
            if (length > remaining) {
                length = remaining;
            }
            byte[] dest = new byte[length];
            System.arraycopy(src, srcPos, dest, 0, length);
            return new LuaBytes(dest);
        }
    }

    public static final class get_string
    extends ThreeArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            byte[] bytes = ((LuaBytes)arg1).bytes;
            int offset = arg2.toint() - 1;
            int length = arg3.toint();
            String val = Buffer.utf8ToString(bytes, offset, length);
            return LuaString.valueOf((String)val);
        }
    }

    public static final class getint
    extends TwoArgFunction {
        public getint(LuaTable table, int id, String name) {
            this.opcode = id;
            this.name = name;
            table.set(name, (LuaValue)this);
        }

        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            byte[] bytes = ((LuaBytes)arg1).bytes;
            int offset = arg2.toint() - 1;
            switch (this.opcode) {
                case 0: {
                    return LuaInteger.valueOf((int)Buffer.bytesToShort(bytes, offset));
                }
                case 1: {
                    return LuaInteger.valueOf((int)Buffer.bytesToInt(bytes, offset));
                }
                case 2: {
                    return LuaInteger.valueOf((long)Buffer.bytesToLong(bytes, offset));
                }
            }
            return NIL;
        }
    }

    public static final class putint
    extends ThreeArgFunction {
        public putint(LuaTable table, int id, String name) {
            this.opcode = id;
            this.name = name;
            table.set(name, (LuaValue)this);
        }

        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            byte[] bytes = ((LuaBytes)arg1).bytes;
            int offset = arg2.toint() - 1;
            int val = arg3.toint();
            switch (this.opcode) {
                case 0: {
                    Buffer.shortToBytes(val, bytes, offset);
                    break;
                }
                case 1: {
                    Buffer.intToBytes(val, bytes, offset);
                    break;
                }
                case 2: {
                    Buffer.longToBytes(val, bytes, offset);
                }
            }
            return NIL;
        }
    }

    public static final class put_bytes
    extends VarArgFunction {
        public Varargs invoke(Varargs args) {
            byte[] dest = ((LuaBytes)args.arg((int)1)).bytes;
            int destPos = args.arg(2).toint() - 1;
            byte[] src = ((LuaBytes)args.arg((int)3)).bytes;
            int length = args.arg(4).toint();
            if (length == 0) {
                length = src.length;
            } else if (length > src.length) {
                return NIL;
            }
            if (destPos < 0 || destPos + length > src.length) {
                return NIL;
            }
            System.arraycopy(src, 0, dest, destPos, length);
            return NIL;
        }
    }

    public static final class put_string
    extends ThreeArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            byte[] bytes = ((LuaBytes)arg1).bytes;
            int offset = arg2.toint() - 1;
            String val = arg3.toString();
            Buffer.stringToUtf8(val, bytes, offset);
            return NIL;
        }
    }

    public static final class newindex
    extends ThreeArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            LuaBytes bytes = (LuaBytes)arg1;
            int offset = arg2.toint() - 1;
            bytes.bytes[offset] = arg3.tobyte();
            return NIL;
        }
    }

    public static final class index
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaBytes bytes = (LuaBytes)arg1;
            int offset = arg2.toint() - 1;
            return LuaInteger.valueOf((int)bytes.bytes[offset]);
        }
    }

    public static final class tostring
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaBytes bytes = (LuaBytes)arg;
            return LuaString.valueOf((String)Arrays.toString(bytes.bytes));
        }
    }

    public static final class len
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaBytes bytes = (LuaBytes)arg;
            return LuaInteger.valueOf((int)bytes.bytes.length);
        }
    }

    public static final class create
    extends VarArgFunction {
        private final LuaValue meta;

        public create(LuaInstance instance) {
            this.meta = instance.getPackage("Bytes");
        }

        public Varargs invoke(Varargs args) {
            int size = args.toint(2);
            LuaBytes bytes = new LuaBytes(size);
            bytes.setmetatable(this.meta);
            return LuaValue.varargsOf((LuaValue[])new LuaValue[]{bytes});
        }
    }

    public static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            meta.set("__len", (LuaValue)new len());
            meta.set("__tostring", (LuaValue)new tostring());
            meta.set("__index", (LuaValue)new index());
            meta.set("__newindex", (LuaValue)new newindex());
            this.instance.registerPackage("Bytes", meta);
            return meta;
        }
    }
}

