/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class SyncCommand
extends Command {
    protected byte[] receiveBuffer;

    public final void execute(Policy policy) throws AerospikeException {
        int i;
        if (policy == null) {
            policy = new Policy();
        }
        int maxIterations = policy.maxRetries + 1;
        int remainingMillis = policy.timeout;
        long limit = System.currentTimeMillis() + (long)remainingMillis;
        int failedNodes = 0;
        int failedConns = 0;
        for (i = 0; i < maxIterations; ++i) {
            Node node = null;
            try {
                node = this.getNode();
                Connection conn = node.getConnection(remainingMillis);
                try {
                    Buffer.intToBytes(remainingMillis, this.sendBuffer, 22);
                    this.send(conn);
                    this.parseResult(conn.getInputStream());
                    conn.updateLastUsed();
                    node.restoreHealth();
                    node.putConnection(conn);
                    return;
                }
                catch (AerospikeException ae) {
                    conn.close();
                    throw ae;
                }
                catch (RuntimeException re) {
                    conn.close();
                    throw re;
                }
                catch (IOException ioe) {
                    conn.close();
                    if (Log.debugEnabled()) {
                        Log.debug("Node " + node + ": " + Util.getErrorMessage(ioe));
                    }
                    node.decreaseHealth();
                }
            }
            catch (AerospikeException.InvalidNode ine) {
                ++failedNodes;
            }
            catch (AerospikeException.Connection ce) {
                node.decreaseHealth();
                if (Log.debugEnabled()) {
                    Log.debug("Node " + node + ": " + Util.getErrorMessage(ce));
                }
                ++failedConns;
            }
            if (policy.timeout > 0 && (remainingMillis = (int)(limit - System.currentTimeMillis())) <= 0) break;
            Util.sleep(policy.sleepBetweenRetries);
        }
        if (Log.debugEnabled()) {
            Log.debug("Client timeout: timeout=" + policy.timeout + " iterations=" + i + " failedNodes=" + failedNodes + " failedConns=" + failedConns);
        }
        throw new AerospikeException.Timeout();
    }

    private final void send(Connection conn) throws IOException {
        int len2;
        OutputStream os = conn.getOutputStream();
        int max = this.sendOffset;
        for (int pos = 0; pos < max; pos += len2) {
            len2 = max - pos;
            if (len2 > 8192) {
                len2 = 8192;
            }
            os.write(this.sendBuffer, pos, len2);
        }
    }

    public static void readFully(InputStream is, byte[] buf, int length) throws IOException {
        int count;
        for (int pos = 0; pos < length; pos += count) {
            count = is.read(buf, pos, length - pos);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    protected abstract Node getNode() throws AerospikeException.InvalidNode;

    protected abstract void parseResult(InputStream var1) throws AerospikeException, IOException;
}

