/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.util.MsgPack;
import com.aerospike.client.util.ThreadLocalData1;
import java.util.ArrayList;
import java.util.HashSet;

public class Command {
    public static final int INFO1_READ = 1;
    public static final int INFO1_GET_ALL = 2;
    public static final int INFO1_NOBINDATA = 32;
    public static final int INFO2_WRITE = 1;
    public static final int INFO2_DELETE = 2;
    public static final int INFO2_GENERATION = 4;
    public static final int INFO2_GENERATION_GT = 8;
    public static final int INFO2_GENERATION_DUP = 16;
    public static final int INFO2_WRITE_UNIQUE = 32;
    public static final int INFO3_LAST = 1;
    public static final int MSG_TOTAL_HEADER_SIZE = 30;
    public static final int FIELD_HEADER_SIZE = 5;
    public static final int OPERATION_HEADER_SIZE = 8;
    public static final int MSG_REMAINING_HEADER_SIZE = 22;
    public static final int DIGEST_SIZE = 20;
    public static final long CL_MSG_VERSION = 2L;
    public static final long AS_MSG_TYPE = 3L;
    protected byte[] sendBuffer = ThreadLocalData1.getBuffer();
    protected int sendOffset = 30;

    public final void setWrite(WritePolicy policy, Operation.Type operation, Key key, Bin[] bins) throws AerospikeException {
        int fieldCount = this.estimateKeySize(key);
        for (Bin bin : bins) {
            this.estimateOperationSize(bin);
        }
        this.begin();
        this.writeHeader(policy, 0, 1, fieldCount, bins.length);
        this.writeKey(key);
        for (Bin bin : bins) {
            this.writeOperation(bin, operation);
        }
        this.end();
    }

    public void setDelete(WritePolicy policy, Key key) {
        int fieldCount = this.estimateKeySize(key);
        this.begin();
        this.writeHeader(policy, 0, 3, fieldCount, 0);
        this.writeKey(key);
        this.end();
    }

    public final void setTouch(WritePolicy policy, Key key) {
        int fieldCount = this.estimateKeySize(key);
        this.estimateOperationSize();
        this.begin();
        this.writeHeader(policy, 0, 1, fieldCount, 1);
        this.writeKey(key);
        this.writeOperation(Operation.Type.TOUCH);
        this.end();
    }

    public final void setExists(Key key) {
        int fieldCount = this.estimateKeySize(key);
        this.begin();
        this.writeHeader(33, 0, fieldCount, 0);
        this.writeKey(key);
        this.end();
    }

    public final void setRead(Key key) {
        int fieldCount = this.estimateKeySize(key);
        this.begin();
        this.writeHeader(3, 0, fieldCount, 0);
        this.writeKey(key);
        this.end();
    }

    public final void setRead(Key key, String[] binNames) {
        int fieldCount = this.estimateKeySize(key);
        for (String binName : binNames) {
            this.estimateOperationSize(binName);
        }
        this.begin();
        this.writeHeader(1, 0, fieldCount, binNames.length);
        this.writeKey(key);
        for (String binName : binNames) {
            this.writeOperation(binName, Operation.Type.READ);
        }
        this.end();
    }

    public final void setReadHeader(Key key) {
        int fieldCount = this.estimateKeySize(key);
        this.estimateOperationSize((String)null);
        this.begin();
        this.writeHeader(1, 0, fieldCount, 1);
        this.writeKey(key);
        this.writeOperation((String)null, Operation.Type.READ);
        this.end();
    }

    public final void setOperate(WritePolicy policy, Key key, Operation[] operations) throws AerospikeException {
        int fieldCount = this.estimateKeySize(key);
        int readAttr = 0;
        int writeAttr = 0;
        boolean readHeader = false;
        for (Operation operation : operations) {
            switch (operation.type) {
                case READ: {
                    readAttr |= 1;
                    if (operation.binName != null) break;
                    readAttr |= 2;
                    break;
                }
                case READ_HEADER: {
                    readAttr |= 1;
                    readHeader = true;
                    break;
                }
                default: {
                    writeAttr = 1;
                }
            }
            this.estimateOperationSize(operation);
        }
        this.begin();
        if (writeAttr != 0) {
            this.writeHeader(policy, readAttr, writeAttr, fieldCount, operations.length);
        } else {
            this.writeHeader(readAttr, writeAttr, fieldCount, operations.length);
        }
        this.writeKey(key);
        for (Operation operation : operations) {
            this.writeOperation(operation);
        }
        if (readHeader) {
            this.writeOperation((String)null, Operation.Type.READ);
        }
        this.end();
    }

    public final void setUdf(Key key, String packageName, String functionName, Value[] args) throws AerospikeException {
        int fieldCount = this.estimateKeySize(key);
        byte[] argBytes = MsgPack.pack(args);
        this.begin();
        this.writeHeader(0, 1, fieldCount += this.estimateUdfSize(packageName, functionName, argBytes), 0);
        this.writeKey(key);
        this.writeField(packageName, 30);
        this.writeField(functionName, 31);
        this.writeField(argBytes, 32);
        this.end();
    }

    public final void setBatchExists(BatchNode.BatchNamespace batchNamespace) {
        ArrayList<Key> keys2 = batchNamespace.keys;
        int byteSize = keys2.size() * 20;
        this.sendOffset = 30 + Buffer.estimateSizeUtf8(batchNamespace.namespace) + 5 + byteSize + 5;
        this.begin();
        this.writeHeader(33, 0, 2, 0);
        this.writeField(batchNamespace.namespace, 0);
        this.writeFieldHeader(byteSize, 6);
        for (Key key : keys2) {
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.sendBuffer, this.sendOffset, digest.length);
            this.sendOffset += digest.length;
        }
        this.end();
    }

    public final void setBatchGet(BatchNode.BatchNamespace batchNamespace, HashSet<String> binNames, int readAttr) {
        ArrayList<Key> keys2 = batchNamespace.keys;
        int byteSize = keys2.size() * 20;
        this.sendOffset = 30 + Buffer.estimateSizeUtf8(batchNamespace.namespace) + 5 + byteSize + 5;
        if (binNames != null) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.begin();
        int operationCount = binNames == null ? 0 : binNames.size();
        this.writeHeader(readAttr, 0, 2, operationCount);
        this.writeField(batchNamespace.namespace, 0);
        this.writeFieldHeader(byteSize, 6);
        for (Key key : keys2) {
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.sendBuffer, this.sendOffset, digest.length);
            this.sendOffset += digest.length;
        }
        if (binNames != null) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    public final void setScan(ScanPolicy policy, String namespace, String setName) {
        int fieldCount = 0;
        if (namespace != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(namespace) + 5;
            ++fieldCount;
        }
        if (setName != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(setName) + 5;
            ++fieldCount;
        }
        this.sendOffset += 7;
        ++fieldCount;
        this.begin();
        int readAttr = 1;
        if (!policy.includeBinData) {
            readAttr = (byte)(readAttr | 0x20);
        }
        this.writeHeader(readAttr, 0, fieldCount, 0);
        if (namespace != null) {
            this.writeField(namespace, 0);
        }
        if (setName != null) {
            this.writeField(setName, 1);
        }
        this.writeFieldHeader(2, 8);
        byte priority = (byte)policy.priority.ordinal();
        priority = (byte)(priority << 4);
        if (policy.failOnClusterChange) {
            priority = (byte)(priority | 8);
        }
        this.sendBuffer[this.sendOffset++] = priority;
        this.sendBuffer[this.sendOffset++] = (byte)policy.scanPercent;
        this.end();
    }

    public final int estimateKeySize(Key key) {
        int fieldCount = 0;
        if (key.namespace != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            ++fieldCount;
        }
        if (key.setName != null) {
            this.sendOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            ++fieldCount;
        }
        this.sendOffset += key.digest.length + 5;
        return ++fieldCount;
    }

    public final int estimateUdfSize(String packageName, String functionName, byte[] bytes) {
        this.sendOffset += Buffer.estimateSizeUtf8(packageName) + 5;
        this.sendOffset += Buffer.estimateSizeUtf8(functionName) + 5;
        this.sendOffset += bytes.length;
        return 3;
    }

    public final void estimateOperationSize(Bin bin) throws AerospikeException {
        this.sendOffset += Buffer.estimateSizeUtf8(bin.name) + 8;
        this.sendOffset += bin.value.estimateSize();
    }

    public final void estimateOperationSize(Operation operation) throws AerospikeException {
        this.sendOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.sendOffset += operation.binValue.estimateSize();
    }

    public final void estimateOperationSize(String binName) {
        this.sendOffset += Buffer.estimateSizeUtf8(binName) + 8;
    }

    public final void estimateOperationSize() {
        this.sendOffset += 8;
    }

    public final void begin() {
        if (this.sendOffset > this.sendBuffer.length) {
            this.sendBuffer = ThreadLocalData1.resizeBuffer(this.sendOffset);
        }
    }

    public final void writeHeader(WritePolicy policy, int readAttr, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int expiration = 0;
        if (policy != null) {
            switch (policy.recordExistsAction) {
                case UPDATE: {
                    break;
                }
                case EXPECT_GEN_EQUAL: {
                    generation = policy.generation;
                    writeAttr |= 4;
                    break;
                }
                case EXPECT_GEN_GT: {
                    generation = policy.generation;
                    writeAttr |= 8;
                    break;
                }
                case FAIL: {
                    writeAttr |= 0x20;
                    break;
                }
                case DUPLICATE: {
                    generation = policy.generation;
                    writeAttr |= 0x10;
                }
            }
            expiration = policy.expiration;
        }
        this.sendBuffer[8] = 22;
        this.sendBuffer[9] = (byte)readAttr;
        this.sendBuffer[10] = (byte)writeAttr;
        this.sendBuffer[11] = 0;
        this.sendBuffer[12] = 0;
        this.sendBuffer[13] = 0;
        Buffer.intToBytes(generation, this.sendBuffer, 14);
        Buffer.intToBytes(expiration, this.sendBuffer, 18);
        this.sendBuffer[22] = 0;
        this.sendBuffer[23] = 0;
        this.sendBuffer[24] = 0;
        this.sendBuffer[25] = 0;
        Buffer.shortToBytes(fieldCount, this.sendBuffer, 26);
        Buffer.shortToBytes(operationCount, this.sendBuffer, 28);
        this.sendOffset = 30;
    }

    public final void writeHeader(int readAttr, int writeAttr, int fieldCount, int operationCount) {
        this.sendBuffer[8] = 22;
        this.sendBuffer[9] = (byte)readAttr;
        this.sendBuffer[10] = (byte)writeAttr;
        for (int i = 11; i < 26; ++i) {
            this.sendBuffer[i] = 0;
        }
        Buffer.shortToBytes(fieldCount, this.sendBuffer, 26);
        Buffer.shortToBytes(operationCount, this.sendBuffer, 28);
        this.sendOffset = 30;
    }

    public final void writeKey(Key key) {
        if (key.namespace != null) {
            this.writeField(key.namespace, 0);
        }
        if (key.setName != null) {
            this.writeField(key.setName, 1);
        }
        this.writeField(key.digest, 4);
    }

    public final void writeOperation(Bin bin, Operation.Type operation) throws AerospikeException {
        int nameLength = Buffer.stringToUtf8(bin.name, this.sendBuffer, this.sendOffset + 8);
        int valueLength = bin.value.write(this.sendBuffer, this.sendOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.sendBuffer, this.sendOffset);
        this.sendOffset += 4;
        this.sendBuffer[this.sendOffset++] = (byte)operation.protocolType;
        this.sendBuffer[this.sendOffset++] = (byte)bin.value.getType();
        this.sendBuffer[this.sendOffset++] = 0;
        this.sendBuffer[this.sendOffset++] = (byte)nameLength;
        this.sendOffset += nameLength + valueLength;
    }

    public final void writeOperation(Operation operation) throws AerospikeException {
        int nameLength = Buffer.stringToUtf8(operation.binName, this.sendBuffer, this.sendOffset + 8);
        int valueLength = operation.binValue.write(this.sendBuffer, this.sendOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.sendBuffer, this.sendOffset);
        this.sendOffset += 4;
        this.sendBuffer[this.sendOffset++] = (byte)operation.type.protocolType;
        this.sendBuffer[this.sendOffset++] = (byte)operation.binValue.getType();
        this.sendBuffer[this.sendOffset++] = 0;
        this.sendBuffer[this.sendOffset++] = (byte)nameLength;
        this.sendOffset += nameLength + valueLength;
    }

    public final void writeOperation(String name, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(name, this.sendBuffer, this.sendOffset + 8);
        Buffer.intToBytes(nameLength + 4, this.sendBuffer, this.sendOffset);
        this.sendOffset += 4;
        this.sendBuffer[this.sendOffset++] = (byte)operation.protocolType;
        this.sendBuffer[this.sendOffset++] = 0;
        this.sendBuffer[this.sendOffset++] = 0;
        this.sendBuffer[this.sendOffset++] = (byte)nameLength;
        this.sendOffset += nameLength;
    }

    public final void writeOperation(Operation.Type operation) {
        Buffer.intToBytes(4, this.sendBuffer, this.sendOffset);
        this.sendOffset += 4;
        this.sendBuffer[this.sendOffset++] = (byte)operation.protocolType;
        this.sendBuffer[this.sendOffset++] = 0;
        this.sendBuffer[this.sendOffset++] = 0;
        this.sendBuffer[this.sendOffset++] = 0;
    }

    public final void writeField(String str, int type) {
        int len2 = Buffer.stringToUtf8(str, this.sendBuffer, this.sendOffset + 5);
        this.writeFieldHeader(len2, type);
        this.sendOffset += len2;
    }

    public final void writeField(byte[] bytes, int type) {
        System.arraycopy(bytes, 0, this.sendBuffer, this.sendOffset + 5, bytes.length);
        this.writeFieldHeader(bytes.length, type);
        this.sendOffset += bytes.length;
    }

    public final void writeFieldHeader(int size, int type) {
        Buffer.intToBytes(size + 1, this.sendBuffer, this.sendOffset);
        this.sendOffset += 4;
        this.sendBuffer[this.sendOffset++] = (byte)type;
    }

    public final void end() {
        long size = (long)(this.sendOffset - 8) | 0x200000000000000L | 0x3000000000000L;
        Buffer.longToBytes(size, this.sendBuffer, 0);
    }

    public final byte[] getSendBuffer() {
        return this.sendBuffer;
    }

    public final int getSendOffset() {
        return this.sendOffset;
    }
}

