/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class BatchCommandGet
extends MultiCommand {
    private final HashMap<Key, BatchItem> keyMap;
    private final HashSet<String> binNames;
    private final Record[] records;

    public BatchCommandGet(Node node, HashMap<Key, BatchItem> keyMap, HashSet<String> binNames, Record[] records) {
        super(node);
        this.keyMap = keyMap;
        this.binNames = binNames;
        this.records = records;
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.receiveOffset = 0;
        while (this.receiveOffset < receiveSize) {
            this.readBytes(22);
            byte resultCode = this.receiveBuffer[5];
            if (resultCode != 0 && resultCode != 2) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.receiveBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int generation = Buffer.bytesToInt(this.receiveBuffer, 6);
            int expiration = Buffer.bytesToInt(this.receiveBuffer, 10);
            int fieldCount = Buffer.bytesToShort(this.receiveBuffer, 18);
            int opCount = Buffer.bytesToShort(this.receiveBuffer, 20);
            Key key = this.parseKey(fieldCount);
            BatchItem item = this.keyMap.get(key);
            if (item != null) {
                if (resultCode != 0) continue;
                int index2 = item.getIndex();
                this.records[index2] = this.parseRecord(opCount, generation, expiration);
                continue;
            }
            if (!Log.debugEnabled()) continue;
            Log.debug("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest));
        }
        return true;
    }

    protected Record parseRecord(int opCount, int generation, int expiration) throws AerospikeException, IOException {
        HashMap<String, Object> bins = null;
        ArrayList<HashMap<String, Object>> duplicates = null;
        for (int i = 0; i < opCount; ++i) {
            this.readBytes(8);
            int opSize = Buffer.bytesToInt(this.receiveBuffer, 0);
            byte particleType = this.receiveBuffer[5];
            int version = this.receiveBuffer[6];
            byte nameSize = this.receiveBuffer[7];
            this.readBytes(nameSize);
            String name = Buffer.utf8ToString(this.receiveBuffer, 0, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            this.readBytes(particleBytesSize);
            Object value = Buffer.bytesToParticle(particleType, this.receiveBuffer, 0, particleBytesSize);
            if (this.binNames != null && !this.binNames.contains(name)) continue;
            Map<String, Object> vmap = null;
            if (version > 0 || duplicates != null) {
                int j;
                if (duplicates == null) {
                    duplicates = new ArrayList<HashMap<String, Object>>(4);
                    duplicates.add(bins);
                    bins = null;
                    for (j = 0; j < version; ++j) {
                        duplicates.add(null);
                    }
                } else {
                    for (j = duplicates.size(); j < version + 1; ++j) {
                        duplicates.add(null);
                    }
                }
                if ((vmap = (Map)duplicates.get(version)) == null) {
                    vmap = new HashMap();
                    duplicates.set(version, (HashMap<String, Object>)vmap);
                }
            } else {
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                vmap = bins;
            }
            vmap.put(name, value);
        }
        if (duplicates != null) {
            while (duplicates.remove(null)) {
            }
        }
        return new Record(bins, (List<Map<String, Object>>)duplicates, generation, expiration);
    }
}

