/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;

public final class PartitionTokenizer {
    private final StringBuilder sb;
    private final byte[] buffer;
    private int length;
    private int offset;

    public PartitionTokenizer(Connection conn, String name) throws AerospikeException {
        Info info = new Info(conn, name);
        this.length = info.getLength();
        if (this.length == 0) {
            throw new AerospikeException.Parse("replicas-write is empty");
        }
        this.buffer = info.getBuffer();
        this.offset = name.length() + 1;
        this.sb = new StringBuilder(32);
    }

    public Partition getNext() throws AerospikeException {
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                if (this.offset == begin) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                }
                int partitionId = Buffer.utf8DigitsToInt(this.buffer, begin, this.offset);
                if (partitionId < 0 || partitionId >= 4096) {
                    String response = this.getTruncatedResponse();
                    String partitionString = Buffer.utf8ToString(this.buffer, begin, this.offset - begin);
                    throw new AerospikeException.Parse("Invalid partition id " + partitionString + " for namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                return new Partition(namespace, partitionId);
            }
            ++this.offset;
        }
        return null;
    }

    private String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }
}

