/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SelectorManager
extends Thread {
    private final ConcurrentLinkedQueue<AsyncCommand> commandQueue = new ConcurrentLinkedQueue();
    private final ArrayDeque<AsyncCommand> timeoutQueue;
    private final Selector selector;
    private final ExecutorService taskThreadPool;
    private final AtomicBoolean awakened = new AtomicBoolean();
    private final long selectorTimeout;
    private volatile boolean valid;

    public SelectorManager(AsyncClientPolicy policy, SelectorProvider provider) throws IOException {
        this.selectorTimeout = policy.asyncSelectorTimeout;
        this.taskThreadPool = policy.asyncTaskThreadPool;
        this.selector = provider.openSelector();
        this.timeoutQueue = new ArrayDeque(policy.asyncMaxCommands);
    }

    public void execute(AsyncCommand command) {
        this.commandQueue.add(command);
        if (this.awakened.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    @Override
    public void run() {
        this.valid = true;
        while (this.valid) {
            try {
                this.runCommands();
            }
            catch (Exception e) {
                if (!this.valid) continue;
                if (Log.warnEnabled()) {
                    Log.warn("Event manager error: " + Util.getErrorMessage(e));
                }
                Util.sleep(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommands() throws Exception {
        Set<SelectionKey> keys2;
        this.checkTimeouts();
        this.registerCommands();
        this.awakened.set(false);
        this.selector.select(this.selectorTimeout);
        if (this.awakened.get()) {
            this.selector.wakeup();
        }
        if ((keys2 = this.selector.selectedKeys()).isEmpty()) {
            return;
        }
        try {
            Iterator<SelectionKey> iter = keys2.iterator();
            while (this.valid && iter.hasNext()) {
                SelectionKey key = iter.next();
                if (!key.isValid()) continue;
                this.processKey(key);
            }
        }
        finally {
            keys2.clear();
        }
    }

    private void registerCommands() {
        AsyncCommand command;
        while ((command = this.commandQueue.poll()) != null) {
            try {
                if (command.timeout > 0) {
                    if (!command.checkTimeout()) continue;
                    this.timeoutQueue.addLast(command);
                }
                command.conn.register(command, this.selector);
            }
            catch (Exception e) {
                command.failConnection(new AerospikeException(e));
            }
        }
    }

    private void checkTimeouts() {
        AsyncCommand command;
        AsyncCommand last = this.timeoutQueue.peekLast();
        while ((command = this.timeoutQueue.pollFirst()) != null) {
            if (command.checkTimeout()) {
                this.timeoutQueue.addLast(command);
            }
            if (command != last) continue;
            break;
        }
    }

    private void processKey(SelectionKey key) {
        AsyncCommand command = (AsyncCommand)key.attachment();
        try {
            int ops = key.readyOps();
            if ((ops & 1) != 0) {
                if (this.taskThreadPool != null) {
                    key.interestOps(0);
                    this.taskThreadPool.execute(command);
                } else {
                    command.read();
                }
            } else if ((ops & 4) != 0) {
                command.write();
            } else if ((ops & 8) != 0) {
                SocketChannel socketChannel = (SocketChannel)key.channel();
                socketChannel.finishConnect();
                key.interestOps(4);
            }
        }
        catch (AerospikeException ae) {
            command.failCommand(ae);
        }
        catch (IOException ioe) {
            command.failCommand(ioe);
        }
        catch (Exception e) {
            command.failCommand(new AerospikeException(e));
        }
    }

    public void close() {
        if (this.valid) {
            this.valid = false;
            this.interrupt();
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.taskThreadPool != null) {
                this.taskThreadPool.shutdownNow();
            }
        }
    }
}

