/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.util.ThreadLocalData1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AsyncRead
extends AsyncSingleCommand {
    private final RecordListener listener;
    private Record record;
    private byte[] receiveBuffer;
    private int receiveOffset;

    public AsyncRead(AsyncCluster cluster, Key key, RecordListener listener) {
        super(cluster, key);
        this.listener = listener;
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) throws AerospikeException {
        this.receiveBuffer = ThreadLocalData1.getBuffer();
        if (this.receiveSize > this.receiveBuffer.length) {
            this.receiveBuffer = ThreadLocalData1.resizeBuffer(this.receiveSize);
        }
        byteBuffer.position(0);
        byteBuffer.get(this.receiveBuffer, 0, this.receiveSize);
        byte resultCode = this.receiveBuffer[5];
        int generation = Buffer.bytesToInt(this.receiveBuffer, 6);
        int expiration = Buffer.bytesToInt(this.receiveBuffer, 10);
        int fieldCount = Buffer.bytesToShort(this.receiveBuffer, 18);
        int opCount = Buffer.bytesToShort(this.receiveBuffer, 20);
        this.receiveOffset = 22;
        if (resultCode == 0) {
            this.record = opCount == 0 ? new Record(null, null, generation, expiration) : this.parseRecord(opCount, fieldCount, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    private final Record parseRecord(int opCount, int fieldCount, int generation, int expiration) throws AerospikeException {
        int i;
        HashMap<String, Object> bins = null;
        ArrayList<HashMap<String, Object>> duplicates = null;
        if (fieldCount != 0) {
            for (i = 0; i < fieldCount; ++i) {
                int fieldSize = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
                this.receiveOffset += 4 + fieldSize;
            }
        }
        for (i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
            byte particleType = this.receiveBuffer[this.receiveOffset + 5];
            int version = this.receiveBuffer[this.receiveOffset + 6];
            byte nameSize = this.receiveBuffer[this.receiveOffset + 7];
            String name = Buffer.utf8ToString(this.receiveBuffer, this.receiveOffset + 8, nameSize);
            this.receiveOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = null;
            value = Buffer.bytesToParticle(particleType, this.receiveBuffer, this.receiveOffset, particleBytesSize);
            this.receiveOffset += particleBytesSize;
            Map<String, Object> vmap = null;
            if (version > 0 || duplicates != null) {
                int j;
                if (duplicates == null) {
                    duplicates = new ArrayList<HashMap<String, Object>>(4);
                    duplicates.add(bins);
                    bins = null;
                    for (j = 0; j < version; ++j) {
                        duplicates.add(null);
                    }
                } else {
                    for (j = duplicates.size(); j < version + 1; ++j) {
                        duplicates.add(null);
                    }
                }
                if ((vmap = (Map)duplicates.get(version)) == null) {
                    vmap = new HashMap();
                    duplicates.set(version, (HashMap<String, Object>)vmap);
                }
            } else {
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                vmap = bins;
            }
            vmap.put(name, value);
        }
        if (duplicates != null) {
            while (duplicates.remove(null)) {
            }
        }
        return new Record(bins, (List<Map<String, Object>>)duplicates, generation, expiration);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

