/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.Buffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AsyncMultiCommand
extends AsyncCommand {
    private final AsyncMultiExecutor parent;
    private final AsyncNode node;
    private final HashSet<String> binNames;
    protected byte[] receiveBuffer;
    protected int receiveSize;
    protected int receiveOffset;
    protected int resultCode;
    protected int generation;
    protected int expiration;
    protected int fieldCount;
    protected int opCount;
    private boolean inHeader = true;

    public AsyncMultiCommand(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node) {
        super(cluster);
        this.parent = parent;
        this.node = node;
        this.binNames = null;
    }

    public AsyncMultiCommand(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, HashSet<String> binNames) {
        super(cluster);
        this.parent = parent;
        this.node = node;
        this.binNames = binNames;
    }

    @Override
    protected final AsyncNode getNode() {
        return this.node;
    }

    @Override
    protected final void read() throws AerospikeException, IOException {
        while (true) {
            if (this.inHeader) {
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
                this.byteBuffer.position(0);
                this.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
                if (this.receiveSize <= 0) {
                    this.finish();
                    return;
                }
                if (this.receiveBuffer == null || this.receiveSize > this.receiveBuffer.length) {
                    this.receiveBuffer = new byte[this.receiveSize];
                }
                this.byteBuffer.clear();
                if (this.receiveSize < this.byteBuffer.capacity()) {
                    this.byteBuffer.limit(this.receiveSize);
                }
                this.inHeader = false;
            }
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.receiveBuffer, this.receiveOffset, this.byteBuffer.limit());
            this.receiveOffset += this.byteBuffer.limit();
            this.byteBuffer.clear();
            if (this.receiveOffset >= this.receiveSize) {
                if (this.parseGroup()) {
                    this.finish();
                    return;
                }
                this.byteBuffer.limit(8);
                this.receiveOffset = 0;
                this.inHeader = true;
                continue;
            }
            int remaining = this.receiveSize - this.receiveOffset;
            if (remaining >= this.byteBuffer.capacity()) continue;
            this.byteBuffer.limit(remaining);
        }
    }

    private final boolean parseGroup() throws AerospikeException {
        this.receiveOffset = 0;
        while (this.receiveOffset < this.receiveSize) {
            this.resultCode = this.receiveBuffer[this.receiveOffset + 5];
            if (this.resultCode != 0 && this.resultCode != 2) {
                throw new AerospikeException(this.resultCode);
            }
            if ((this.receiveBuffer[this.receiveOffset + 3] & 1) != 0) {
                return true;
            }
            this.generation = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset + 6);
            this.expiration = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset + 10);
            this.fieldCount = Buffer.bytesToShort(this.receiveBuffer, this.receiveOffset + 18);
            this.opCount = Buffer.bytesToShort(this.receiveBuffer, this.receiveOffset + 20);
            this.receiveOffset += 22;
            Key key = this.parseKey();
            this.parseRow(key);
        }
        return false;
    }

    protected final Key parseKey() {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        for (int i = 0; i < this.fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
            this.receiveOffset += 4;
            byte fieldtype = this.receiveBuffer[this.receiveOffset++];
            int size = fieldlen - 1;
            if (fieldtype == 4) {
                digest = new byte[size];
                System.arraycopy(this.receiveBuffer, this.receiveOffset, digest, 0, size);
                this.receiveOffset += size;
                continue;
            }
            if (fieldtype == 0) {
                namespace = new String(this.receiveBuffer, this.receiveOffset, size);
                this.receiveOffset += size;
                continue;
            }
            if (fieldtype != 1) continue;
            setName = new String(this.receiveBuffer, this.receiveOffset, size);
            this.receiveOffset += size;
        }
        return new Key(namespace, digest, setName);
    }

    protected Record parseRecordWithDuplicates() throws AerospikeException {
        HashMap<String, Object> bins = null;
        ArrayList<HashMap<String, Object>> duplicates = null;
        for (int i = 0; i < this.opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
            byte particleType = this.receiveBuffer[this.receiveOffset + 5];
            int version = this.receiveBuffer[this.receiveOffset + 6];
            byte nameSize = this.receiveBuffer[this.receiveOffset + 7];
            String name = Buffer.utf8ToString(this.receiveBuffer, this.receiveOffset + 8, nameSize);
            this.receiveOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.receiveBuffer, this.receiveOffset, particleBytesSize);
            this.receiveOffset += particleBytesSize;
            if (this.binNames != null && !this.binNames.contains(name)) continue;
            Map<String, Object> vmap = null;
            if (version > 0 || duplicates != null) {
                int j;
                if (duplicates == null) {
                    duplicates = new ArrayList<HashMap<String, Object>>(4);
                    duplicates.add(bins);
                    bins = null;
                    for (j = 0; j < version; ++j) {
                        duplicates.add(null);
                    }
                } else {
                    for (j = duplicates.size(); j < version + 1; ++j) {
                        duplicates.add(null);
                    }
                }
                if ((vmap = (Map)duplicates.get(version)) == null) {
                    vmap = new HashMap();
                    duplicates.set(version, (HashMap<String, Object>)vmap);
                }
            } else {
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                vmap = bins;
            }
            vmap.put(name, value);
        }
        if (duplicates != null) {
            while (duplicates.remove(null)) {
            }
        }
        return new Record(bins, (List<Map<String, Object>>)duplicates, this.generation, this.expiration);
    }

    protected Record parseRecord() throws AerospikeException {
        HashMap<String, Object> bins = null;
        for (int i = 0; i < this.opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
            byte particleType = this.receiveBuffer[this.receiveOffset + 5];
            byte nameSize = this.receiveBuffer[this.receiveOffset + 7];
            String name = Buffer.utf8ToString(this.receiveBuffer, this.receiveOffset + 8, nameSize);
            this.receiveOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.receiveBuffer, this.receiveOffset, particleBytesSize);
            this.receiveOffset += particleBytesSize;
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            bins.put(name, value);
        }
        return new Record(bins, null, this.generation, this.expiration);
    }

    @Override
    protected void onSuccess() {
        this.parent.childSuccess();
    }

    @Override
    protected void onFailure(AerospikeException e) {
        this.parent.childFailure(e);
    }

    protected abstract void parseRow(Key var1) throws AerospikeException;
}

