/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.Policy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LargeStack {
    private static final String Filename = "lstack";
    private final AerospikeClient client;
    private final Policy policy;
    private final Key key;
    private final Value binName;

    public LargeStack(AerospikeClient client, Policy policy, Key key, String binName) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
    }

    public final void create(String configName) throws AerospikeException {
        Value configValue = LargeStack.getConfigValue(configName);
        this.client.execute(this.policy, this.key, Filename, "lstack_create", this.binName, configValue);
    }

    public final void push(String configName, Value value) throws AerospikeException {
        Value configValue = LargeStack.getConfigValue(configName);
        this.client.execute(this.policy, this.key, Filename, "lstack_create_and_push", this.binName, value, configValue);
    }

    public final void push(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, Filename, "lstack_push", this.binName, value);
    }

    public final void trim(int trimCount) throws AerospikeException {
        this.client.execute(this.policy, this.key, Filename, "lstack_trim", this.binName, Value.get(trimCount));
    }

    public final List<?> peek(int peekCount) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, Filename, "lstack_peek", this.binName, Value.get(peekCount));
    }

    public final List<?> peek(int peekCount, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, Filename, "lstack_peek_then_filter", this.binName, Value.get(peekCount), Value.get(filterName), Value.get(filterArgs));
    }

    public final int size() throws AerospikeException {
        return (Integer)this.client.execute(this.policy, this.key, Filename, "lstack_size", this.binName);
    }

    public final Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, Filename, "lstack_config", this.binName);
    }

    protected static final Value getConfigValue(String configName) {
        if (configName != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Package", configName);
            return Value.getAsMap(map);
        }
        return Value.getAsNull();
    }
}

