/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import gnu.crypto.util.Base64;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public final class Util {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getErrorMessage(Exception e) {
        Throwable cause = e.getCause();
        if (e instanceof SocketException || e instanceof AerospikeException.Connection || cause instanceof SocketTimeoutException) {
            return e.getMessage();
        }
        if (e instanceof EOFException || cause instanceof EOFException) {
            return EOFException.class.getName();
        }
        StringWriter sw = new StringWriter(1000);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileEncodeBase64(String path) throws AerospikeException {
        try {
            File file = new File(path);
            byte[] bytes = new byte[(int)file.length()];
            FileInputStream in = new FileInputStream(file);
            try {
                int len2 = 0;
                for (int pos = 0; pos < bytes.length; pos += len2) {
                    len2 = in.read(bytes, pos, bytes.length - pos);
                }
            }
            finally {
                in.close();
            }
            return Base64.encode((byte[])bytes, (int)0, (int)bytes.length, (boolean)false);
        }
        catch (Exception e) {
            throw new AerospikeException("Failed to read " + path, e);
        }
    }
}

