/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.Log;

public final class ThreadLocalData2 {
    private static final int THREAD_LOCAL_CUTOFF = 131072;
    private static final ThreadLocal<byte[]> BufferThreadLocal2 = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[8192];
        }
    };

    public static byte[] getBuffer() {
        return BufferThreadLocal2.get();
    }

    public static byte[] resizeBuffer(int size) {
        if (size > 131072) {
            if (Log.debugEnabled()) {
                Log.debug("Thread " + Thread.currentThread().getId() + " allocate buffer2 on heap " + size);
            }
            return new byte[size];
        }
        if (Log.debugEnabled()) {
            Log.debug("Thread " + Thread.currentThread().getId() + " resize buffer2 to " + size);
        }
        BufferThreadLocal2.set(new byte[size]);
        return BufferThreadLocal2.get();
    }
}

