/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.QueryExecutor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class RecordSet {
    public static final KeyRecord END = new KeyRecord(null, null);
    private final QueryExecutor executor;
    private final BlockingQueue<KeyRecord> queue;
    private KeyRecord record;
    private volatile boolean valid = true;

    protected RecordSet(QueryExecutor executor, int capacity) {
        this.executor = executor;
        this.queue = new ArrayBlockingQueue<KeyRecord>(capacity);
    }

    public final boolean next() throws AerospikeException {
        if (this.valid) {
            try {
                this.record = this.queue.take();
                if (this.record == END) {
                    this.executor.checkForException();
                    this.valid = false;
                }
            }
            catch (InterruptedException ie) {
                this.valid = false;
            }
        }
        return this.valid;
    }

    public final void close() {
        this.valid = false;
    }

    public final Key getKey() {
        return this.record.key;
    }

    public final Record getRecord() {
        return this.record.record;
    }

    protected final boolean put(KeyRecord record) {
        if (this.valid) {
            try {
                this.queue.put(record);
            }
            catch (InterruptedException ie) {
                this.abort();
            }
        }
        return this.valid;
    }

    private final void abort() {
        this.valid = false;
        while (true) {
            try {
                this.queue.put(END);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

