/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.lua.LuaExecutor;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.QueryAggregateCommand;
import com.aerospike.client.query.QueryCommand;
import com.aerospike.client.query.QueryExecutor;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.luaj.vm2.LuaValue;

public final class QueryAggregateExecutor
extends QueryExecutor {
    private final BlockingQueue<LuaValue> inputQueue;
    private final ResultSet resultSet;
    private final Thread luaThread;

    public QueryAggregateExecutor(QueryPolicy policy, Statement statement, Node[] nodes, String packageName, String functionName, Value[] functionArgs) {
        super(policy, statement);
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        this.inputQueue = new ArrayBlockingQueue<LuaValue>(500);
        this.resultSet = new ResultSet(this, policy.recordQueueSize);
        LuaExecutor luaExecutor = new LuaExecutor(statement, this.inputQueue, this.resultSet);
        LuaValue.valueOf((int)0);
        this.luaThread = new Thread(luaExecutor);
        this.luaThread.start();
        this.startThreads(nodes);
    }

    @Override
    protected QueryCommand createCommand(Node node) {
        return new QueryAggregateCommand(node, this.inputQueue);
    }

    @Override
    protected void sendCompleted() {
        try {
            this.inputQueue.put(LuaValue.NIL);
            this.luaThread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.resultSet.put(ResultSet.END);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

